/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

class HasCorrelatedCRsVisitor
implements Visitor {
    private boolean hasCorrelatedCRs;

    HasCorrelatedCRsVisitor() {
    }

    @Override
    public Visitable visit(Visitable visitable) {
        if (visitable instanceof ColumnReference) {
            if (((ColumnReference)visitable).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (visitable instanceof VirtualColumnNode) {
            if (((VirtualColumnNode)visitable).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (visitable instanceof MethodCallNode && (((MethodCallNode)visitable).getMethodName().equals("getTriggerExecutionContext") || ((MethodCallNode)visitable).getMethodName().equals("TriggerOldTransitionRows") || ((MethodCallNode)visitable).getMethodName().equals("TriggerNewTransitionRows"))) {
            this.hasCorrelatedCRs = true;
        }
        return visitable;
    }

    @Override
    public boolean stopTraversal() {
        return this.hasCorrelatedCRs;
    }

    @Override
    public boolean skipChildren(Visitable visitable) {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }

    boolean hasCorrelatedCRs() {
        return this.hasCorrelatedCRs;
    }

    void setHasCorrelatedCRs(boolean bl) {
        this.hasCorrelatedCRs = bl;
    }
}

