/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UpgradeHAStore
implements DBConstants {
    private BrokerResources br = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private DBManager dbMgr = DBManager.getDBManager();
    private String brokerID = this.dbMgr.getBrokerID();

    UpgradeHAStore() throws BrokerException {
        if (!Globals.getHAEnabled()) {
            String reason = this.br.getKString("B1230", this.brokerID);
            throw new BrokerException(this.br.getKString("B3208", reason));
        }
    }

    void upgradeStore(Connection conn) throws BrokerException {
        this.logger.logToAll(8, this.br.getString("B1232", String.valueOf(410), this.brokerID));
        DAOFactory daoFactory = this.dbMgr.getDAOFactory();
        int version = -1;
        try {
            VersionDAO verDAO = daoFactory.getVersionDAO();
            version = verDAO.getStoreVersion(conn);
        }
        catch (BrokerException verDAO) {
            // empty catch block
        }
        boolean createStore = false;
        if (version == 410) {
            BrokerDAO bkrDAO = daoFactory.getBrokerDAO();
            HABrokerInfo bkrInfo = bkrDAO.getBrokerInfo(conn, this.brokerID);
            if (bkrInfo != null) {
                String reason = this.br.getString("B1231", this.brokerID);
                throw new BrokerException(this.br.getKString("B3208", reason));
            }
        } else if (version == -1) {
            createStore = true;
        } else {
            String reason = this.br.getString("B3092", String.valueOf(version), String.valueOf(410));
            throw new BrokerException(this.br.getKString("B3208", reason));
        }
        try {
            if (createStore) {
                DBTool.createTables(conn);
            }
        }
        catch (Throwable e) {
            String url = this.dbMgr.getCreateDBURL();
            if (url == null || url.length() == 0) {
                url = this.dbMgr.getOpenDBURL();
            }
            String errorMsg = this.br.getKString("B3073", url);
            this.logger.logToAll(32, errorMsg, (Object)e);
            throw new BrokerException(errorMsg, e);
        }
        try {
            conn.setAutoCommit(false);
            this.upgradeStoreSessions(conn);
            this.upgradeDestinations(conn);
            this.upgradeInterests(conn);
            this.upgradeMessages(conn);
            this.upgradeTxns(conn);
            this.logger.logToAll(8, this.br.getString("B1106"));
        }
        catch (Exception e) {
            this.logger.logToAll(32, "B1233", (Object)this.brokerID);
            try {
                DestinationDAO dstDAO = daoFactory.getDestinationDAO();
                dstDAO.deleteAll(conn);
                ConsumerDAO conDAO = daoFactory.getConsumerDAO();
                conDAO.deleteAll(conn);
                MessageDAO msgDAO = daoFactory.getMessageDAO();
                msgDAO.deleteAll(conn);
                TransactionDAO txnDAO = daoFactory.getTransactionDAO();
                txnDAO.deleteAll(conn);
            }
            catch (Exception ex) {
                this.logger.logStack(32, "B4117", (Object)"Failed to clean up after upgrade failed", (Throwable)ex);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(this.br.getKString("B3208", e.getMessage()), e);
        }
    }

    void upgradeStoreSessions(Connection conn) throws BrokerException {
        StoreSessionDAO sesDAO = this.dbMgr.getDAOFactory().getStoreSessionDAO();
        String oldtable = "MQSES41S" + this.brokerID;
        String insertAllStoreSessionsFromOldSQL = new StringBuilder(128).append("INSERT INTO ").append(sesDAO.getTableName()).append(" ( ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(") SELECT ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(oldtable).toString();
        Statement stmt = null;
        Exception myex = null;
        try {
            stmt = conn.createStatement();
            DBManager.executeStatement(stmt, insertAllStoreSessionsFromOldSQL);
            conn.commit();
        }
        catch (Exception e) {
            myex = e;
            String errorMsg = this.br.getKString("B4284");
            this.logger.logStack(32, errorMsg, (Throwable)e);
            throw new BrokerException(errorMsg, e);
        }
        finally {
            Util.close(null, stmt, null, myex);
        }
    }

    void upgradeDestinations(Connection conn) throws BrokerException {
        DestinationDAO dstDAO = this.dbMgr.getDAOFactory().getDestinationDAO();
        String oldtable = "MQDST41S" + this.brokerID;
        String getAllDestFromOldSQL = new StringBuilder(128).append("SELECT ").append("DESTINATION").append(", ").append("CREATED_TS").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(" FROM ").append(oldtable).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(dstDAO.getTableName()).append(')').toString();
        String insertDestSQL = new StringBuilder(128).append("INSERT INTO ").append(dstDAO.getTableName()).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates();
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Destination dst = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertDestSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllDestFromOldSQL);
            while (rs.next()) {
                ConnectionUID cUID;
                Object obj = Util.readObject(rs, 1);
                dst = (Destination)obj;
                long createdTS = rs.getLong(2);
                String destName = dst.getUniqueName();
                int isLocal = dst.getIsLocal() ? 1 : 0;
                long connectionID = -1L;
                long connectedTS = -1L;
                if (isLocal > 0 && (cUID = dst.getConnectionUID()) != null) {
                    connectedTS = rs.getLong(3);
                    connectionID = cUID.longValue();
                }
                long sessionID = rs.getLong(4);
                try {
                    pstmt.setString(1, destName);
                    Util.setObject(pstmt, 2, dst);
                    pstmt.setInt(3, isLocal);
                    Util.setLong(pstmt, 4, connectionID);
                    Util.setLong(pstmt, 5, connectedTS);
                    pstmt.setLong(6, sessionID);
                    pstmt.setLong(7, createdTS);
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertDestSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertDestSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4162", dst == null ? "loading" : dst.getUniqueName());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    private void upgradeInterests(Connection conn) throws BrokerException {
        ConsumerDAO conDAO = this.dbMgr.getDAOFactory().getConsumerDAO();
        String oldtbl = "MQCON41S" + this.brokerID;
        String getAllInterestFromOldSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER").append(", ").append("CREATED_TS").append(", ").append("ID").append(" FROM ").append(oldtbl).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(conDAO.getTableName()).append(')').toString();
        String insertInterestSQL = new StringBuilder(128).append("INSERT INTO ").append(conDAO.getTableName()).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates();
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        Consumer consumer = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertInterestSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllInterestFromOldSQL);
            while (rs.next()) {
                consumer = (Consumer)Util.readObject(rs, 1);
                long createdTS = rs.getLong(2);
                String durableName = null;
                String clientID = null;
                if (consumer instanceof Subscription) {
                    Subscription sub = (Subscription)consumer;
                    durableName = sub.getDurableName();
                    clientID = sub.getClientID();
                }
                try {
                    pstmt.setLong(1, consumer.getConsumerUID().longValue());
                    Util.setObject(pstmt, 2, consumer);
                    Util.setString(pstmt, 3, durableName);
                    Util.setString(pstmt, 4, clientID);
                    pstmt.setLong(5, createdTS);
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertInterestSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertInterestSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4168", consumer == null ? "loading" : consumer.toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    private void upgradeMessages(Connection conn) throws BrokerException {
        String oldtbl = "MQMSG41S" + this.brokerID;
        String sql = null;
        int nummsg = 0;
        Statement stmt = null;
        ResultSet rs = null;
        SQLException myex = null;
        try {
            sql = "SELECT COUNT(*) FROM " + oldtbl;
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, sql);
            if (rs.next()) {
                nummsg = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                myex = e;
                this.logger.log(32, "B4166", (Object)sql, (Throwable)e);
                throw new BrokerException(this.br.getString("B4166", sql), e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        this.logger.logToAll(8, this.br.getString("B1118", String.valueOf(nummsg)));
        this.doUpgradeMsg(conn);
    }

    private void doUpgradeMsg(Connection conn) throws BrokerException {
        MessageDAO msgDAO = this.dbMgr.getDAOFactory().getMessageDAO();
        String oldmsgtbl = "MQMSG41S" + this.brokerID;
        HashMap<String, String> msgToDst = new HashMap<String, String>();
        String getAllMsgFromOldSQL = new StringBuilder(128).append("SELECT ").append("ID").append(", ").append("MESSAGE").append(", ").append("DESTINATION_ID").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(" FROM ").append(oldmsgtbl).toString();
        Statement stmt = null;
        ResultSet rs = null;
        String msgID = null;
        Packet msg = null;
        Exception myex = null;
        try {
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllMsgFromOldSQL);
            while (rs.next()) {
                msgID = rs.getString(1);
                msg = new Packet(false);
                msg.generateTimestamp(false);
                msg.generateSequenceNumber(false);
                Blob blob = rs.getBlob(2);
                InputStream is = blob.getBinaryStream();
                msg.readPacket(is);
                is.close();
                String dstID = rs.getString(3);
                long sessionID = rs.getLong(4);
                long createdTS = rs.getLong(5);
                try {
                    msgDAO.insert(conn, dstID, msg, null, null, sessionID, createdTS, true, false);
                }
                catch (BrokerException be) {
                    if (be.getStatusCode() == 409) {
                        this.logger.log(16, be.getMessage() + ": Ignore");
                    }
                    throw be;
                }
                msgToDst.put(msgID, dstID);
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4163", msg == null ? msgID : msg.getSysMessageID().toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        ConsumerStateDAO stateDAO = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        String oldstatetbl = "MQCONSTATE41S" + this.brokerID;
        String getAllStateFromOldSQL = new StringBuilder(128).append("SELECT ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(" FROM ").append(oldstatetbl).append(" WHERE ").append("STATE").append(" <> ").append(2).toString();
        String insertStateSQL = new StringBuilder(128).append("INSERT INTO ").append(stateDAO.getTableName()).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates();
        PreparedStatement pstmt = null;
        String mid = null;
        long cuid = 0L;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertStateSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllStateFromOldSQL);
            while (rs.next()) {
                mid = rs.getString(1);
                cuid = rs.getLong(2);
                int state = rs.getInt(3);
                long txnID = rs.getLong(4);
                long createdTS = rs.getLong(5);
                String dst = (String)msgToDst.get(mid);
                if (dst == null) continue;
                try {
                    pstmt.setString(1, mid);
                    pstmt.setLong(2, cuid);
                    pstmt.setInt(3, state);
                    if (txnID > 0L) {
                        pstmt.setLong(4, txnID);
                    } else {
                        pstmt.setNull(4, -5);
                    }
                    pstmt.setLong(5, createdTS);
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertStateSQL + "]", e);
                    throw ex;
                }
            }
            msgToDst.clear();
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
        }
        catch (SQLException e) {
            myex = e;
            String errorMsg = this.br.getKString("B4163", mid == null ? "loading" : mid);
            this.logger.logStack(32, errorMsg, (Throwable)e);
            throw new BrokerException(errorMsg, e);
        }
        finally {
            Util.close(rs, stmt, null, myex);
            Util.close(null, pstmt, null, myex);
        }
    }

    private void upgradeTxns(Connection conn) throws BrokerException {
        TransactionDAO txnDAO = this.dbMgr.getDAOFactory().getTransactionDAO();
        String oldtxntbl = "MQTXN41S" + this.brokerID;
        String getAllTxnsFromOldSQL = new StringBuilder(128).append("SELECT ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(" FROM ").append(oldtxntbl).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(txnDAO.getTableName()).append(')').toString();
        String insertTxnSQL = new StringBuilder(128).append("INSERT INTO ").append(txnDAO.getTableName()).append(" ( ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates();
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        TransactionUID tid = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertTxnSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllTxnsFromOldSQL);
            while (rs.next()) {
                long id = rs.getLong(1);
                tid = new TransactionUID(id);
                int type = rs.getInt(2);
                int state = rs.getInt(3);
                TransactionState txnState = (TransactionState)Util.readObject(rs, 4);
                txnState.setState(state);
                BrokerAddress txnHomeBroker = (BrokerAddress)Util.readObject(rs, 5);
                TransactionBroker[] txnBrokers = (TransactionBroker[])Util.readObject(rs, 6);
                long sessionID = rs.getLong(7);
                try {
                    pstmt.setLong(1, id);
                    pstmt.setInt(2, type);
                    pstmt.setInt(3, state);
                    pstmt.setInt(4, txnState.getType().intValue());
                    JMQXid jmqXid = txnState.getXid();
                    if (jmqXid != null) {
                        pstmt.setString(5, jmqXid.toString());
                    } else {
                        pstmt.setNull(5, 12);
                    }
                    Util.setObject(pstmt, 6, txnState);
                    Util.setObject(pstmt, 7, txnHomeBroker);
                    Util.setObject(pstmt, 8, txnBrokers);
                    pstmt.setLong(9, sessionID);
                    pstmt.setLong(10, txnState.getExpirationTime());
                    pstmt.setLong(11, txnState.getLastAccessTime());
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertTxnSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertTxnSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4172", tid == null ? "loading" : tid.toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }
}

