/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

public class UniqueID {
    static final int TIMESTAMP_BITS = 40;
    static final int COUNTER_BITS = 8;
    static final long MAX_SLEEP_SHIFT = 7000L;
    static long max_sleep_shift = 7000L;
    static final long WRAP_TIME = 0xFFFFFFFFFFL;
    static final long TIMESTAMP_MASK = 0xFFFFFFFFFFL;
    static final int MAX_COUNTER = 255;
    static long last_timestamp = 0L;
    static short counter = 0;
    static long timestamp_advances = 0L;

    public static synchronized long generateID(short prefix) {
        long curr_timestamp = System.currentTimeMillis();
        if (curr_timestamp > last_timestamp) {
            last_timestamp = curr_timestamp;
            counter = 0;
        } else if (curr_timestamp < last_timestamp) {
            long delta = last_timestamp - curr_timestamp;
            if (delta <= max_sleep_shift) {
                while (curr_timestamp <= last_timestamp) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(last_timestamp - curr_timestamp);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    curr_timestamp = System.currentTimeMillis();
                }
            } else {
                curr_timestamp = last_timestamp + 1L;
                if (++timestamp_advances % 200L == 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            last_timestamp = curr_timestamp;
            counter = 0;
        } else if (counter < 255) {
            counter = (short)(counter + 1);
        } else {
            counter = 0;
            while (curr_timestamp <= last_timestamp) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception delta) {
                    // empty catch block
                }
                curr_timestamp = System.currentTimeMillis();
            }
            last_timestamp = curr_timestamp;
        }
        long id = prefix;
        id <<= 48;
        curr_timestamp = (curr_timestamp & 0xFFFFFFFFFFL) << 8;
        id |= curr_timestamp;
        if ((id |= (long)counter) == 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            id = UniqueID.generateID(prefix);
        }
        return id;
    }

    public static long age(long id) {
        return UniqueID.age(id, System.currentTimeMillis());
    }

    public static long age(long id, long currentTime) {
        long curr_time = currentTime;
        long id_time = UniqueID.getTimestamp(id);
        if ((curr_time &= 0xFFFFFFFFFFL) > id_time) {
            return curr_time - id_time;
        }
        return curr_time + (0xFFFFFFFFFFL - id_time);
    }

    public static void setMaxSleepShift(long n) {
        max_sleep_shift = n;
    }

    public static int hashCode(long id) {
        return (int)(id ^ id >>> 32);
    }

    public static long getTimestamp(long id) {
        return id >>> 8 & 0xFFFFFFFFFFL;
    }

    public static short getPrefix(long id) {
        return (short)(id >>> 48);
    }
}

