/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BooleanExpression;
import org.glassfish.rmic.tools.tree.CommaExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.DoubleExpression;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.FloatExpression;
import org.glassfish.rmic.tools.tree.IntegerExpression;
import org.glassfish.rmic.tools.tree.LongExpression;
import org.glassfish.rmic.tools.tree.StringExpression;
import org.glassfish.rmic.tools.tree.UnaryExpression;
import org.glassfish.rmic.tools.tree.Vset;

public class BinaryExpression
extends UnaryExpression {
    Expression left;

    BinaryExpression(int op, long where, Type type, Expression left, Expression right) {
        super(op, where, type, right);
        this.left = left;
    }

    @Override
    public Expression order() {
        if (this.precedence() > this.left.precedence()) {
            UnaryExpression e = (UnaryExpression)this.left;
            this.left = e.right;
            e.right = this.order();
            return e;
        }
        return this;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.left.checkValue(env, ctx, vset, exp);
        vset = this.right.checkValue(env, ctx, vset, exp);
        int tm = this.left.type.getTypeMask() | this.right.type.getTypeMask();
        if ((tm & 0x2000) != 0) {
            return vset;
        }
        this.selectType(env, ctx, tm);
        if (this.type.isType(13)) {
            env.error(this.where, "invalid.args", opNames[this.op]);
        }
        return vset;
    }

    @Override
    public boolean isConstant() {
        switch (this.op) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return this.left.isConstant() && this.right.isConstant();
            }
        }
        return false;
    }

    Expression eval(int a, int b) {
        return this;
    }

    Expression eval(long a, long b) {
        return this;
    }

    Expression eval(float a, float b) {
        return this;
    }

    Expression eval(double a, double b) {
        return this;
    }

    Expression eval(boolean a, boolean b) {
        return this;
    }

    Expression eval(String a, String b) {
        return this;
    }

    @Override
    Expression eval() {
        if (this.left.op == this.right.op) {
            switch (this.left.op) {
                case 62: 
                case 63: 
                case 64: 
                case 65: {
                    return this.eval(((IntegerExpression)this.left).value, ((IntegerExpression)this.right).value);
                }
                case 66: {
                    return this.eval(((LongExpression)this.left).value, ((LongExpression)this.right).value);
                }
                case 67: {
                    return this.eval(((FloatExpression)this.left).value, ((FloatExpression)this.right).value);
                }
                case 68: {
                    return this.eval(((DoubleExpression)this.left).value, ((DoubleExpression)this.right).value);
                }
                case 61: {
                    return this.eval(((BooleanExpression)this.left).value, ((BooleanExpression)this.right).value);
                }
                case 69: {
                    return this.eval(((StringExpression)this.left).value, ((StringExpression)this.right).value);
                }
            }
        }
        return this;
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        this.left = this.left.inline(env, ctx);
        this.right = this.right.inline(env, ctx);
        return this.left == null ? this.right : new CommaExpression(this.where, this.left, this.right);
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        this.left = this.left.inlineValue(env, ctx);
        this.right = this.right.inlineValue(env, ctx);
        try {
            return this.eval().simplify();
        }
        catch (ArithmeticException e) {
            return this;
        }
    }

    @Override
    public Expression copyInline(Context ctx) {
        BinaryExpression e = (BinaryExpression)this.clone();
        if (this.left != null) {
            e.left = this.left.copyInline(ctx);
        }
        if (this.right != null) {
            e.right = this.right.copyInline(ctx);
        }
        return e;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + (this.left != null ? this.left.costInline(thresh, env, ctx) : 0) + (this.right != null ? this.right.costInline(thresh, env, ctx) : 0);
    }

    void codeOperation(Environment env, Context ctx, Assembler asm) {
        throw new CompilerError("codeOperation: " + opNames[this.op]);
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        if (this.type.isType(0)) {
            Label l1 = new Label();
            Label l2 = new Label();
            this.codeBranch(env, ctx, asm, l1, true);
            asm.add(true, this.where, 18, 0);
            asm.add(true, this.where, 167, l2);
            asm.add(l1);
            asm.add(true, this.where, 18, 1);
            asm.add(l2);
        } else {
            this.left.codeValue(env, ctx, asm);
            this.right.codeValue(env, ctx, asm);
            this.codeOperation(env, ctx, asm);
        }
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " ");
        if (this.left != null) {
            this.left.print(out);
        } else {
            out.print("<null>");
        }
        out.print(" ");
        if (this.right != null) {
            this.right.print(out);
        } else {
            out.print("<null>");
        }
        out.print(")");
    }
}

