/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.web.WebModule;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.HashSet;
import java.util.Set;
import org.apache.catalina.core.DynamicServletRegistrationImpl;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.glassfish.security.common.Role;
import org.glassfish.web.deployment.annotation.handlers.ServletSecurityHandler;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;

class DynamicWebServletRegistrationImpl
extends DynamicServletRegistrationImpl {
    private final WebBundleDescriptor wbd;
    private WebComponentDescriptor wcd;
    private final WebModule webModule;
    private String runAsRoleName = null;
    private ServletSecurityElement servletSecurityElement = null;

    public DynamicWebServletRegistrationImpl(StandardWrapper wrapper, WebModule webModule) {
        super(wrapper, (StandardContext)webModule);
        this.webModule = webModule;
        this.wbd = webModule.getWebBundleDescriptor();
        if (this.wbd == null) {
            throw new IllegalStateException("Missing WebBundleDescriptor for " + this.getContext().getName());
        }
        this.wbd.setPolicyModified(true);
        this.wcd = this.wbd.getWebComponentByCanonicalName(wrapper.getName());
        if (this.wcd == null) {
            this.wcd = new WebComponentDescriptorImpl();
            this.wcd.setName(wrapper.getName());
            this.wcd.setCanonicalName(wrapper.getName());
            this.wbd.addWebComponentDescriptor(this.wcd);
            String servletClassName = wrapper.getServletClassName();
            if (servletClassName != null) {
                Class<? extends Servlet> clazz = wrapper.getServletClass();
                if (clazz == null) {
                    if (wrapper.getServlet() != null) {
                        clazz = wrapper.getServlet().getClass();
                    } else {
                        try {
                            clazz = this.loadServletClass(servletClassName);
                        }
                        catch (Exception ex) {
                            throw new IllegalArgumentException(ex);
                        }
                    }
                    wrapper.setServletClass(clazz);
                }
                this.processServletAnnotations(clazz, this.wbd, this.wcd, wrapper);
            } else if (wrapper.getJspFile() == null) {
                throw new RuntimeException("Programmatic servlet registration without any supporting servlet class or jsp file");
            }
        }
    }

    public Set<String> addMapping(String ... urlPatterns) {
        Set conflicts = super.addMapping(urlPatterns);
        if (conflicts.isEmpty() && urlPatterns != null && urlPatterns.length > 0) {
            for (String urlPattern : urlPatterns) {
                this.wcd.addUrlPattern(urlPattern);
            }
        }
        return conflicts;
    }

    public void setRunAsRole(String roleName) {
        super.setRunAsRole(roleName);
        this.runAsRoleName = roleName;
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        this.servletSecurityElement = constraint;
        HashSet<String> conflictUrls = new HashSet<String>(this.wcd.getUrlPatternsSet());
        conflictUrls.removeAll(ServletSecurityHandler.getUrlPatternsWithoutSecurityConstraint(this.wcd));
        conflictUrls.addAll(super.setServletSecurity(constraint));
        return conflictUrls;
    }

    protected void setServletClassName(String className) {
        super.setServletClassName(className);
        try {
            Class<? extends Servlet> clazz = this.loadServletClass(className);
            super.setServletClass(clazz);
            this.processServletAnnotations(clazz, this.wbd, this.wcd, this.wrapper);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected void setServletClass(Class<? extends Servlet> clazz) {
        super.setServletClass(clazz);
        this.processServletAnnotations(clazz, this.wbd, this.wcd, this.wrapper);
    }

    private void processServletAnnotations(Class<? extends Servlet> clazz, WebBundleDescriptor webBundleDescriptor, WebComponentDescriptor wcd, StandardWrapper wrapper) {
        if (clazz.isAnnotationPresent(DeclareRoles.class)) {
            DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
            for (String roleName : declareRoles.value()) {
                webBundleDescriptor.addRole(new Role(roleName));
                this.webModule.declareRoles(new String[]{roleName});
            }
        }
        if (clazz.isAnnotationPresent(MultipartConfig.class)) {
            MultipartConfig mpConfig = clazz.getAnnotation(MultipartConfig.class);
            wrapper.setMultipartLocation(mpConfig.location());
            wrapper.setMultipartMaxFileSize(mpConfig.maxFileSize());
            wrapper.setMultipartMaxRequestSize(mpConfig.maxRequestSize());
            wrapper.setMultipartFileSizeThreshold(mpConfig.fileSizeThreshold());
        }
    }

    void postProcessAnnotations() {
        Class clazz = this.wrapper.getServletClass();
        if (clazz == null) {
            return;
        }
        if (this.wcd.getRunAsIdentity() == null) {
            String roleName = this.runAsRoleName;
            if (roleName == null && clazz.isAnnotationPresent(RunAs.class)) {
                RunAs runAs = clazz.getAnnotation(RunAs.class);
                roleName = runAs.value();
            }
            if (roleName != null) {
                super.setRunAsRole(roleName);
                this.wbd.addRole(new Role(roleName));
                RunAsIdentityDescriptor runAsDesc = new RunAsIdentityDescriptor();
                runAsDesc.setRoleName(roleName);
                this.wcd.setRunAsIdentity(runAsDesc);
            }
        }
        ServletSecurityElement ssElement = this.servletSecurityElement;
        if (this.servletSecurityElement == null && clazz.isAnnotationPresent(ServletSecurity.class)) {
            ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
            ssElement = new ServletSecurityElement(servletSecurity);
        }
        if (ssElement != null) {
            this.webModule.processServletSecurityElement(ssElement, this.wbd, this.wcd);
        }
    }

    private Class<? extends Servlet> loadServletClass(String className) throws ClassNotFoundException {
        return this.ctx.getLoader().getClassLoader().loadClass(className);
    }
}

