/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.connection;

import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.utility.StringScanner;
import com.sun.jdo.spi.persistence.utility.DoubleLinkedList;
import com.sun.jdo.spi.persistence.utility.Linkable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class ConnectionManager {
    private String driverName = null;
    private transient String expandedDriverName = null;
    private String url = null;
    private transient String expandedUrl = null;
    private String userName = null;
    private transient String expandedUserName = null;
    private char[] password = null;
    private transient String expandedPassword = null;
    private int minPool = 0;
    private int maxPool = 0;
    private transient int poolSize = 0;
    private transient boolean pooling = false;
    transient DoubleLinkedList freeList = null;
    transient DoubleLinkedList busyList = null;
    private transient Hashtable xactConnections = null;
    transient boolean shutDownPending = false;
    private transient boolean connectionBlocking = false;
    private int msInterval = 0;
    private int msWait = 0;
    private static final int DEFAULT_RETRY_INTERVAL = 1000;
    private transient boolean initialized = false;
    private int loginTimeout;
    private transient ConnectionImpl freeConn = null;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)ConnectionManager.class.getClassLoader());
    static final String SQL_SUCCESS = "00000";
    static final String SQL_WARNING = "01000";
    static final String SQL_CURSOR_OP = "01001";
    static final String SQL_DISCONNECT = "01002";
    static final String SQL_NULL_ELIM = "01003";
    static final String SQL_R_TRUNC = "01004";
    static final String SQL_INSUFF_ITEM = "01005";
    static final String SQL_NOT_REVOKED = "01006";
    static final String SQL_NOT_GRANTED = "01007";
    static final String SQL_ZERO_BIT_PAD = "01008";
    static final String SQL_COND_TOO_LONG = "01009";
    static final String SQL_QUERY_TOO_LONG = "0100A";
    static final String SQL_NO_DATA = "02000";
    static final String SQL_DYN_ERROR = "07000";
    static final String SQL_USING_NO_PARAM = "07001";
    static final String SQL_USING_NO_TARGET = "07002";
    static final String SQL_CURSOR_NOEXE = "07003";
    static final String SQL_USING_REQ = "07004";
    static final String SQL_PREP_NO_CURSOR = "07005";
    static final String SQL_RESTRIC_ATTR = "07006";
    static final String SQL_USING_RESULTS = "07007";
    static final String SQL_INVAL_DESC_CNT = "07008";
    static final String SQL_INVAL_DESC_IDX = "07009";
    static final String SQL_CONN = "08000";
    static final String SQL_CLIENT_NO_CONN = "08001";
    static final String SQL_CONN_IN_USE = "08002";
    static final String SQL_NO_CONN = "08003";
    static final String SQL_REJECT_CONN = "08004";
    static final String SQL_CONN_FAIL = "08006";
    static final String SQL_TRANS_UNK = "08007";
    static final String SQL_NO_SUPPORT = "0A000";
    static final String SQL_NO_SUPPORT_MULTI = "0A001";
    static final String SQL_INVALID_VALUE = "21000";
    static final String SQL_DATA = "22000";
    static final String SQL_DATA_RTRUNC = "22001";
    static final String SQL_DATA_NULL = "22002";
    static final String SQL_OUT_OF_RANGE = "22003";
    static final String SQL_DATA_EXCEPT = "22005";
    static final String SQL_DATETIME_FMT = "22007";
    static final String SQL_DATETIME_OVFLO = "22008";
    static final String SQL_TIMEZONE = "22009";
    static final String SQL_SUBSTR_ERROR = "22011";
    static final String SQL_DIV_BY_ZERO = "22012";
    static final String SQL_INTERVAL_OVFLO = "22015";
    static final String SQL_INVAL_CHAR_CAST = "22018";
    static final String SQL_INVAL_ESCAPE_CHAR = "22019";
    static final String SQL_CHAR_NOT_REP = "22021";
    static final String SQL_IND_OVERFLOW = "22022";
    static final String SQL_INVAL_PARAM_VALUE = "22023";
    static final String SQL_UNTERM_C_STR = "22024";
    static final String SQL_INVAL_ESCAPE_SEQ = "22025";
    static final String SQL_STR_LEN_MISMATCH = "22026";
    static final String SQL_TRIM_ERROR = "22027";
    static final String SQL_INTEG_CONSTRAINT = "23000";
    static final String SQL_INVAL_CURSOR_STATE = "24000";
    static final String SQL_INVAL_TRANS_STATE = "25000";
    static final String SQL_INVAL_SQL_NAME = "26000";
    static final String SQL_INVAL_AUTH = "28000";
    static final String SQL_SYNTAX_DIRECT = "2A000";
    static final String SQL_DESC_EXIST = "2B000";
    static final String SQL_INVAL_CHAR_SET = "2C000";
    static final String SQL_INVAL_TRANS_TERM = "2D000";
    static final String SQL_INVAL_CONN_NAME = "2E000";
    static final String SQL_INVAL_SQL_DESC_NAME = "33000";
    static final String SQL_INVAL_CURSOR_NAME = "34000";
    static final String SQL_INVAL_COND_NUM = "35000";
    static final String SQL_SYNTAX_DYNAMIC = "37000";
    static final String SQL_AMBIG_CURSOR = "3C000";
    static final String SQL_INVAL_CATALOG = "3D000";
    static final String SQL_INVAL_SCHEMA_NAME = "3F000";
    static final String SQL_TRANS_ROLLBACK = "40000";
    static final String SQL_TRANS_SERIAL_FAIL = "40001";
    static final String SQL_TRANS_INTEG = "40002";
    static final String SQL_TRANS_COMP_UNK = "40003";
    static final String SQL_SYNTAX = "42000";
    static final String SQL_CHECK_OPT = "44000";
    static final String SQL_RMT_DB_ACCESS = "HZ   ";

    public ConnectionManager() {
    }

    public ConnectionManager(String driverName) throws ClassNotFoundException, SQLException {
        this();
        try {
            this.setDriverName(driverName);
            this.startUp();
        }
        catch (SQLException se) {
            throw se;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
    }

    public ConnectionManager(String driverName, String url) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(driverName);
        this.setURL(url);
        this.startUp();
    }

    public ConnectionManager(String driverName, String url, String userName) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(driverName);
        this.setURL(url);
        this.setUserName(userName);
        this.startUp();
    }

    public ConnectionManager(String driverName, String url, String userName, char[] password) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(driverName);
        this.setURL(url);
        this.setUserName(userName);
        this.setPassword(password);
        this.startUp();
    }

    public ConnectionManager(String driverName, String url, String userName, char[] password, int minPool, int maxPool) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(driverName);
        this.setURL(url);
        this.setUserName(userName);
        this.setPassword(password);
        this.setMinPool(minPool);
        this.setMaxPool(maxPool);
        this.startUp();
    }

    public ConnectionManager(String driverName, String url, String userName, char[] password, int minPool, int maxPool, int msWait) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(driverName);
        this.setURL(url);
        this.setUserName(userName);
        this.setPassword(password);
        this.setMinPool(minPool);
        this.setMaxPool(maxPool);
        this.setMsWait(msWait);
        this.setMsInterval(1000);
        this.startUp();
    }

    public ConnectionManager(String driverName, String url, String userName, char[] password, int minPool, int maxPool, int msWait, int msInterval) throws ClassNotFoundException, SQLException {
        this();
        this.setDriverName(driverName);
        this.setURL(url);
        this.setUserName(userName);
        this.setPassword(password);
        this.setMinPool(minPool);
        this.setMaxPool(maxPool);
        this.setMsWait(msWait);
        this.setMsInterval(msInterval);
        this.startUp();
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.shutDownPending) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.isdown")), SQL_NO_CONN);
            throw se;
        }
        ConnectionImpl conn = this.checkXact();
        if (conn == null) {
            if (!this.pooling) {
                conn = (ConnectionImpl)this.getConnection(this.userName, this.password);
                conn.setPooled(false);
                conn.checkXact();
            } else {
                if (this.freeList.size <= 0) {
                    if (this.poolSize < this.maxPool) {
                        this.expandPool(1);
                    }
                    if (!this.connectionBlocking) {
                        SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.maxpool")), SQL_INVAL_PARAM_VALUE);
                        throw se;
                    }
                    this.waitForConnection();
                }
                if ((conn = (ConnectionImpl)this.freeList.removeFromHead()) == null) {
                    SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.badvalue")), SQL_INVAL_PARAM_VALUE);
                    throw se;
                }
                conn.setPooled(true);
                conn.checkXact();
                this.busyList.insertAtTail((Linkable)conn);
            }
        }
        conn.setFreePending(false);
        return conn;
    }

    public synchronized Connection getConnection(String userName, char[] password) throws SQLException {
        boolean debug = logger.isLoggable(300);
        if (this.shutDownPending) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw se;
        }
        ConnectionImpl conn = this.checkXact();
        if (conn == null) {
            if (this.freeConn != null) {
                if (debug) {
                    logger.finest("sqlstore.connection.conncectiomgr.found", (Object)this.freeConn);
                }
                conn = this.freeConn;
                this.freeConn = null;
            } else {
                conn = new ConnectionImpl(DriverManager.getConnection(this.expandedUrl, this.expandAttribute(userName), this.expandAttribute(new String(password))), this.expandedUrl, this.expandAttribute(userName), this);
                if (debug) {
                    logger.finest("sqlstore.connection.conncectiomgr.getnewconn", (Object)conn);
                }
            }
            conn.checkXact();
        } else if (!conn.getUserName().equals(this.expandAttribute(userName))) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.getconnection.mismatch")), SQL_NO_CONN);
            throw se;
        }
        conn.setFreePending(false);
        conn.setPooled(false);
        this.busyList.insertAtTail((Linkable)conn);
        return conn;
    }

    public synchronized Connection getConnection(String url, String userName, String password) throws SQLException {
        boolean debug = logger.isLoggable(300);
        if (this.shutDownPending) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw se;
        }
        ConnectionImpl conn = this.checkXact();
        if (conn == null) {
            if (this.freeConn != null) {
                if (debug) {
                    logger.finest("sqlstore.connection.conncectiomgr.found", (Object)this.freeConn);
                }
                conn = this.freeConn;
                this.freeConn = null;
            } else {
                conn = new ConnectionImpl(DriverManager.getConnection(this.expandAttribute(url), this.expandAttribute(userName), this.expandAttribute(password)), this.expandAttribute(url), this.expandAttribute(userName), this);
                if (debug) {
                    logger.finest("sqlstore.connection.conncectiomgr.getnewconn", (Object)conn);
                }
            }
            conn.checkXact();
        } else if (!conn.getURL().equals(this.expandAttribute(url)) || !conn.getUserName().equals(this.expandAttribute(userName))) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.getconnection.mismatch")), SQL_NO_CONN);
            throw se;
        }
        conn.setFreePending(false);
        conn.setPooled(false);
        this.busyList.insertAtTail((Linkable)conn);
        return conn;
    }

    private synchronized ConnectionImpl checkXact() {
        Object tran = null;
        if (tran == null) {
            return null;
        }
        return (ConnectionImpl)this.xactConnections.get(tran);
    }

    public void startUp() throws ClassNotFoundException, SQLException {
        if (this.initialized) {
            return;
        }
        this.busyList = new DoubleLinkedList();
        this.xactConnections = new Hashtable();
        this.expandedDriverName = this.expandAttribute(this.driverName);
        if (this.expandedDriverName == null) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.nulldriver")), SQL_INVALID_VALUE);
            throw se;
        }
        this.expandedUrl = this.expandAttribute(this.url);
        if (this.expandedUrl == null) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.nullurl")), SQL_INVALID_VALUE);
            throw se;
        }
        this.expandedUserName = this.expandAttribute(this.userName);
        if (this.expandedUserName == null) {
            this.expandedUserName = "";
        }
        this.expandedPassword = this.expandAttribute(new String(this.password));
        if (this.expandedPassword == null) {
            this.expandedPassword = "";
        }
        try {
            Class.forName(this.expandedDriverName);
            if (this.minPool > 0 && this.maxPool >= this.minPool) {
                this.pooling = true;
                this.freeList = new DoubleLinkedList();
                this.expandPool(this.minPool);
            } else if (this.minPool == 0 && this.maxPool == 0) {
                this.pooling = false;
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        this.initialized = true;
    }

    public synchronized void shutDown() throws SQLException {
        this.shutDownPending = true;
        if (this.pooling) {
            this.connectionBlocking = false;
            this.pooling = false;
            this.initialized = false;
            for (ConnectionImpl conn = (ConnectionImpl)this.freeList.getHead(); conn != null; conn = (ConnectionImpl)conn.getNext()) {
                conn.close();
                continue;
            }
            this.freeList = null;
        }
    }

    protected void finalize() {
        try {
            this.shutDown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized String getDriverName() {
        return this.driverName;
    }

    public synchronized void setDriverName(String driverName) throws SQLException {
        if (driverName == null) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.nulldriver")), SQL_INVALID_VALUE);
            throw se;
        }
        this.driverName = driverName;
    }

    public synchronized String getURL() {
        return this.url;
    }

    public synchronized void setURL(String url) throws SQLException {
        if (url == null) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.nullurl")), SQL_INVALID_VALUE);
            throw se;
        }
        this.url = url;
    }

    public synchronized String getUserName() {
        return this.userName;
    }

    public synchronized void setUserName(String userName) throws SQLException {
        this.userName = userName;
    }

    public synchronized char[] getPassword() {
        return this.password;
    }

    public synchronized void setPassword(char[] password) throws SQLException {
        this.password = password;
    }

    public synchronized int getMinPool() {
        return this.minPool;
    }

    public synchronized void setMinPool(int minPool) throws SQLException {
        if (this.shutDownPending) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw se;
        }
        if (minPool < 0) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.zero")), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        if (minPool < this.minPool) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.badnew"), Integer.toString(minPool), Integer.toString(minPool)), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        if (this.pooling && minPool > this.maxPool) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.poolsize")), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        this.minPool = minPool;
    }

    public synchronized int getMaxPool() {
        return this.maxPool;
    }

    public synchronized void setMaxPool(int maxPool) throws SQLException {
        if (this.shutDownPending) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw se;
        }
        if (maxPool < 0) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.zero"), Integer.toString(maxPool)), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        if (this.pooling && maxPool < this.maxPool) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.badnew"), Integer.toString(maxPool), Integer.toString(maxPool)), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        if (maxPool < this.minPool) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.poolsize")), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        this.maxPool = maxPool;
    }

    public synchronized int getMsWait() {
        return this.msWait;
    }

    public synchronized void setMsWait(int msWait) throws SQLException {
        if (msWait < 0) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.badvalue"), Integer.toString(msWait)), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        if (msWait > 0) {
            this.msWait = msWait;
            this.connectionBlocking = true;
        } else {
            this.msWait = msWait;
            this.connectionBlocking = false;
        }
    }

    public synchronized int getMsInterval() {
        return this.msInterval;
    }

    public synchronized void setMsInterval(int msInterval) throws SQLException {
        if (msInterval < 0 || this.msWait < msInterval) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.badnew"), "MsInterval", "MsWait"), SQL_INVAL_PARAM_VALUE);
            throw se;
        }
        this.msInterval = msInterval;
    }

    public synchronized String toString() {
        return null;
    }

    synchronized void associateXact(Transaction tran, ConnectionImpl conn) {
        if (tran != null) {
            this.xactConnections.put(tran, conn);
        }
    }

    synchronized void disassociateXact(Transaction tran, ConnectionImpl conn, boolean free) throws SQLException {
        Object xactConn = null;
        if (tran != null) {
            xactConn = (ConnectionImpl)this.xactConnections.remove(tran);
        }
        if (tran == null || xactConn.equals(conn)) {
            if (free) {
                if (!conn.connectionManager.shutDownPending) {
                    this.freeList.insertAtTail((Linkable)conn);
                } else {
                    conn.close();
                }
            }
        } else {
            SQLException se = new SQLException(StringScanner.createParamString("Internal Error: transaction mismatch"), SQL_TRANS_UNK);
            throw se;
        }
    }

    private synchronized void expandPool(int connections) throws SQLException {
        ConnectionImpl conn = null;
        if (this.shutDownPending) {
            SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.isdown")), SQL_CONN_FAIL);
            throw se;
        }
        for (int i = 0; i < connections; ++i) {
            if (this.poolSize >= this.maxPool) {
                SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.maxpool")), SQL_CONN_FAIL);
                throw se;
            }
            conn = new ConnectionImpl(DriverManager.getConnection(this.expandedUrl, this.expandedUserName, this.expandedPassword), this.expandedUrl, this.expandedUserName, this);
            conn.setPooled(true);
            this.freeList.insertAtTail((Linkable)conn);
            ++this.poolSize;
            continue;
        }
    }

    private String expandAttribute(String envname) throws SQLException {
        String attribute = null;
        if (attribute != null) {
            return attribute;
        }
        return envname;
    }

    private synchronized void waitForConnection() throws SQLException {
        int interval = this.msInterval;
        int wait = this.msWait;
        int totalTime = 0;
        boolean done = false;
        do {
            if (this.freeList.size > 0) {
                done = true;
                continue;
            }
            if (this.poolSize < this.maxPool) {
                this.expandPool(1);
                done = true;
            }
            if (totalTime >= wait) {
                SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.conntimeout")), SQL_CONN_FAIL);
                throw se;
            }
            try {
                this.wait(interval);
            }
            catch (InterruptedException ie) {
                SQLException se = new SQLException(StringScanner.createParamString(I18NHelper.getMessage((ResourceBundle)messages, (String)"connection.connectionmanager.threaditerupted")), SQL_CONN_FAIL);
                throw se;
            }
            totalTime += interval;
        } while (!done);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    protected synchronized void replaceFreeConnection(ConnectionImpl c) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.connection.conncectiomgr.replacefreeconn", (Object)this.freeConn);
        }
        if (this.freeConn != null) {
            this.freeConn.release();
        }
        this.freeConn = c;
    }
}

