/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeExtension;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectionDefinitionUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolReconfigHelper;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SecurityMapUtils;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ResourcePrincipalDescriptor;
import com.sun.enterprise.resource.listener.UnpooledConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.util.i18n.StringManager;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.TransactionSupport;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.config.types.Property;

public class ConnectorConnectionPoolAdminServiceImpl
extends ConnectorService {
    private static final StringManager I18N = StringManager.getManager(ConnectorConnectionPoolAdminServiceImpl.class);

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        _logger.log(Level.FINEST, "createConnectorConnectionPool(connectorPoolObj={0})", connectorPoolObj);
        if (connectorPoolObj == null) {
            throw new ConnectorRuntimeException(I18N.getString("ccp_adm.wrong_params_for_create"));
        }
        PoolInfo poolInfo = connectorPoolObj.getPoolInfo();
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        try {
            this._runtime.getResourceNamingService().publishObject((GenericResourceInfo)poolInfo, jndiNameForPool, (Object)connectorPoolObj, true);
            ManagedConnectionFactory mcf = this.obtainManagedConnectionFactory(poolInfo);
            if (mcf == null) {
                this._runtime.getResourceNamingService().unpublishObject((GenericResourceInfo)poolInfo, jndiNameForPool);
                String i18nMsg = I18N.getString("ccp_adm.failed_to_create_mcf", (Object)poolInfo);
                ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
                _logger.log(Level.SEVERE, "rardeployment.mcf_creation_failure", poolInfo);
                _logger.log(Level.SEVERE, "", cre);
                throw cre;
            }
        }
        catch (NamingException ex) {
            String i18nMsg = I18N.getString("ccp_adm.failed_to_publish_in_jndi", (Object)poolInfo);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ex);
            _logger.log(Level.SEVERE, "rardeployment.pool_jndi_bind_failure", poolInfo);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (NullPointerException ex) {
            block7: {
                try {
                    this._runtime.getResourceNamingService().unpublishObject((GenericResourceInfo)poolInfo, jndiNameForPool);
                }
                catch (NamingException ne) {
                    if (!_logger.isLoggable(Level.FINE)) break block7;
                    _logger.log(Level.FINE, "Failed to unbind connection pool object  ", poolInfo);
                }
            }
            String i18nMsg = I18N.getString("ccp_adm.failed_to_register_mcf", (Object)poolInfo);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ex);
            _logger.log(Level.SEVERE, "rardeployment.mcf_registration_failure", poolInfo);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public void deleteConnectorConnectionPool(PoolInfo poolInfo) throws ConnectorRuntimeException {
        this.deleteConnectorConnectionPool(poolInfo, false);
    }

    public void deleteConnectorConnectionPool(PoolInfo poolInfo, boolean cascade) throws ConnectorRuntimeException {
        if (poolInfo == null) {
            _logger.log(Level.WARNING, "ccp_adm.null_pool_name");
            String i18nMsg = I18N.getString("ccp_adm.null_pool_name");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        this.killPool(poolInfo);
        boolean result = _registry.removeManagedConnectionFactory(poolInfo);
        if (!result) {
            _logger.log(Level.FINE, "Failed to remove the MCF: {0}", poolInfo);
            return;
        }
        try {
            SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
            this._runtime.getResourceNamingService().unpublishObject((GenericResourceInfo)poolInfo, jndiNameForPool);
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_removal_from_jndi_error", poolInfo);
            String i18nMsg = I18N.getString("ccp_adm.failed_to_remove_from_jndi", (Object)poolInfo);
            throw new ConnectorRuntimeException(i18nMsg, (Throwable)ne);
        }
    }

    public void killPool(PoolInfo poolInfo) {
        this._runtime.getPoolManager().killPool(poolInfo);
    }

    public static Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName, String resType) {
        return ConnectionDefinitionUtils.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName, resType);
    }

    public boolean testConnectionPool(PoolInfo poolInfo) throws ResourceException {
        _logger.log(Level.FINEST, "testConnectionPool(poolInfo={0})", poolInfo);
        ManagedConnection con = null;
        try {
            con = (ManagedConnection)this.getUnpooledConnection(poolInfo, null, false);
            boolean bl = true;
            return bl;
        }
        catch (Exception re) {
            _logger.log(Level.SEVERE, "Exception while creating an unpooled [test] connection for pool " + String.valueOf(poolInfo), re);
            throw new ResourceException(re.getLocalizedMessage() + " Please check the server.log for more details.", (Throwable)re);
        }
        finally {
            try {
                if (con != null) {
                    con.destroy();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected Subject getDefaultSubject(PoolInfo poolInfo, ManagedConnectionFactory mcf, ResourcePrincipalDescriptor prin) throws ResourceException {
        ResourcePrincipalDescriptor resourcePrincipalDescriptor = null;
        if (prin == null) {
            try {
                resourcePrincipalDescriptor = this.getDefaultResourcePrincipal(poolInfo, mcf);
            }
            catch (NamingException ne) {
                _logger.log(Level.WARNING, "jdbc.pool_not_reachable", ne.getMessage());
                throw new ResourceException("This pool is not bound in JNDI: " + String.valueOf(poolInfo), (Throwable)ne);
            }
        } else {
            resourcePrincipalDescriptor = prin;
        }
        Subject defaultSubject = ConnectionPoolObjectsUtils.createSubject(mcf, resourcePrincipalDescriptor);
        _logger.log(Level.FINE, "Using subject: {0}", defaultSubject);
        return defaultSubject;
    }

    protected ManagedConnection getManagedConnection(ManagedConnectionFactory mcf, Subject defaultSubject, ConnectionRequestInfo cReqInfo) throws ResourceException {
        ManagedConnection mc = null;
        mc = mcf.createManagedConnection(defaultSubject, cReqInfo);
        return mc;
    }

    public Object getUnpooledConnection(PoolInfo poolInfo, ResourcePrincipalDescriptor principal, boolean returnConnectionHandle) throws ResourceException {
        ManagedConnectionFactory mcf = null;
        ResourcePool poolToDeploy = null;
        boolean needToUndeployPool = false;
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        try {
            if (!this.isPoolReferredByResource(poolInfo) && _registry.isMCFCreated(poolInfo)) {
                this.unloadAndKillPool(poolInfo);
            }
            mcf = this.obtainManagedConnectionFactory(poolInfo, new Hashtable());
        }
        catch (ConnectorRuntimeException re) {
            _logger.fine("getUnpooledConnection:: obtainManagedConnectionFactory threw exception. So doing checkAndLoadPoolResource ...");
            if (this.checkAndLoadPool(poolInfo)) {
                _logger.fine("getUnpooledConnection:: checkAndLoadPoolResource is true");
                try {
                    if (!this.isConnectorConnectionPoolDeployed(poolInfo)) {
                        _logger.fine("getUnpooledConnection :: isConnectorConnectionPoolDeployed is false");
                        try {
                            poolToDeploy = (ResourcePool)runtime.getResources(poolInfo).getResourceByName(ResourcePool.class, poolInfo.getName());
                            runtime.getResourceDeployer(poolToDeploy).deployResource((Object)poolToDeploy);
                            _logger.log(Level.FINE, "getUnpooledConnection:: force deployed the ConnectionPool: {0}", poolInfo);
                            needToUndeployPool = true;
                        }
                        catch (Exception e) {
                            _logger.log(Level.SEVERE, "Could not do actual deploy for {0}", poolInfo);
                            throw new ResourceException((Throwable)e);
                        }
                    }
                    _logger.fine("getUnpooledConnection :: Now calling obtainManagedConnectionFactory again");
                    mcf = this.obtainManagedConnectionFactory(poolInfo);
                    _logger.fine("getUnpooledConnection:: done obtainManagedConnectionFactory again");
                }
                catch (ConnectorRuntimeException creAgain) {
                    String l10nMsg = I18N.getString("pingpool.cannot_obtain_mcf", (Object)poolInfo);
                    _logger.log(Level.WARNING, "jdbc.pool_not_reachable", l10nMsg);
                    ResourceException e = new ResourceException(l10nMsg);
                    e.initCause((Throwable)creAgain);
                    throw e;
                }
            }
            _logger.log(Level.WARNING, "jdbc.pool_not_reachable", re.getMessage());
            String l10nMsg = I18N.getString("pingpool.cannot_obtain_mcf", (Object)poolInfo);
            ResourceException e = new ResourceException(l10nMsg);
            e.initCause((Throwable)re);
            throw e;
        }
        ResourcePrincipalDescriptor resourcePrincipalDescriptor = null;
        if (principal == null) {
            try {
                resourcePrincipalDescriptor = this.getDefaultResourcePrincipal(poolInfo, mcf);
            }
            catch (NamingException ne) {
                _logger.log(Level.WARNING, "jdbc.pool_not_reachable", ne.getMessage());
                throw new ResourceException("This pool is not bound in JNDI: " + String.valueOf(poolInfo), (Throwable)ne);
            }
        } else {
            resourcePrincipalDescriptor = principal;
        }
        Subject defaultSubject = ConnectionPoolObjectsUtils.createSubject(mcf, resourcePrincipalDescriptor);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("using subject: " + String.valueOf(defaultSubject));
        }
        ManagedConnection mc = mcf.createManagedConnection(defaultSubject, null);
        if (needToUndeployPool && poolToDeploy != null) {
            _logger.fine("getUnpooledConnection :: need to force undeploy pool");
            try {
                runtime.getResourceDeployer(poolToDeploy).undeployResource((Object)poolToDeploy);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "getUnpooledConnection: error undeploying pool", e);
            }
            _logger.fine("getUnpooledConnection :: done.. force undeploy of pool");
        }
        mc.addConnectionEventListener((ConnectionEventListener)new UnpooledConnectionEventListener());
        return returnConnectionHandle ? mc.getConnection(defaultSubject, null) : mc;
    }

    private boolean isPoolReferredByResource(PoolInfo poolInfo) {
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        boolean isJdbcPoolReferredInServerInstance = false;
        List extensions = Globals.getDefaultHabitat().getAllServices(ConnectorRuntimeExtension.class, new Annotation[0]);
        for (ConnectorRuntimeExtension extension : extensions) {
            isJdbcPoolReferredInServerInstance = extension.isConnectionPoolReferredInServerInstance(poolInfo);
        }
        return resUtil.isPoolReferredInServerInstance(poolInfo) || isJdbcPoolReferredInServerInstance;
    }

    public String getPropertyValue(String prop, ConnectorConnectionPool connectorConnectionPool) {
        String result = null;
        ConnectorDescriptorInfo cdi = connectorConnectionPool.getConnectorDescriptorInfo();
        Set<ConnectorConfigProperty> mcfConfigProperties = cdi.getMCFConfigProperties();
        for (ConnectorConfigProperty envProp : mcfConfigProperties) {
            if (!envProp.getName().toUpperCase(Locale.getDefault()).equals(prop)) continue;
            result = envProp.getValue();
        }
        return result;
    }

    private ResourcePrincipalDescriptor getDefaultResourcePrincipal(PoolInfo poolInfo, ManagedConnectionFactory mcf) throws NamingException {
        return this.getDefaultResourcePrincipal(poolInfo, mcf, null);
    }

    private ResourcePrincipalDescriptor getDefaultResourcePrincipal(PoolInfo poolInfo, ManagedConnectionFactory mcf, Hashtable env) throws NamingException {
        String userName = null;
        String password = null;
        ConnectorConnectionPool connectorConnectionPool = null;
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        connectorConnectionPool = (ConnectorConnectionPool)this._runtime.getResourceNamingService().lookup((GenericResourceInfo)poolInfo, jndiNameForPool, env);
        userName = this.getPropertyValue("USERNAME", connectorConnectionPool);
        if (userName == null) {
            userName = this.getPropertyValue("USER", connectorConnectionPool);
        }
        password = this.getPropertyValue("PASSWORD", connectorConnectionPool);
        try {
            password = RelativePathResolver.getRealPasswordFromAlias((String)password);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "unable_to_get_password_from_alias", e);
        }
        if (userName == null || userName.isBlank()) {
            userName = ConnectionPoolObjectsUtils.getValueFromMCF("User", poolInfo, mcf);
            password = ConnectionPoolObjectsUtils.getValueFromMCF("Password", poolInfo, mcf);
        }
        return new ResourcePrincipalDescriptor(userName, password);
    }

    public void switchOnMatching(PoolInfo poolInfo) throws ConnectorRuntimeException {
        try {
            ConnectorConnectionPool origCcp = this.getOriginalConnectorConnectionPool(poolInfo);
            origCcp.setMatchConnections(true);
            SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
            this._runtime.getResourceNamingService().unpublishObject((GenericResourceInfo)poolInfo, jndiNameForPool);
            this._runtime.getResourceNamingService().publishObject((GenericResourceInfo)poolInfo, jndiNameForPool, (Object)origCcp, true);
        }
        catch (NamingException e) {
            ConnectorRuntimeException ex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)ex.initCause((Throwable)e);
        }
    }

    private ConnectorConnectionPool getOriginalConnectorConnectionPool(PoolInfo poolInfo) throws NamingException {
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        return (ConnectorConnectionPool)this._runtime.getResourceNamingService().lookup((GenericResourceInfo)poolInfo, jndiNameForPool);
    }

    private ConnectorConnectionPool getConnectorConnectionPool(PoolInfo poolInfo) throws ConnectorRuntimeException, NamingException {
        return this.getConnectorConnectionPool(poolInfo, null);
    }

    private ConnectorConnectionPool getConnectorConnectionPool(PoolInfo poolInfo, Hashtable env) throws ConnectorRuntimeException, NamingException {
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        ConnectorConnectionPool connectorConnectionPool = (ConnectorConnectionPool)this._runtime.getResourceNamingService().lookup((GenericResourceInfo)poolInfo, jndiNameForPool, env);
        if (connectorConnectionPool == null) {
            String i18nMsg = I18N.getString("ccp_adm.null_pool", (Object)poolInfo);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_object_null", poolInfo);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        return connectorConnectionPool;
    }

    private ActiveResourceAdapter getResourceAdapter(ConnectorConnectionPool connectorConnectionPool) throws ConnectorRuntimeException {
        String rarName = connectorConnectionPool.getConnectorDescriptorInfo().getRarName();
        ActiveResourceAdapter activeResourceAdapter = this.getActiveResourceAdapter(rarName);
        if (activeResourceAdapter == null) {
            String i18nMsg = I18N.getString("ccp_adm.active_ra_not_init", (Object)rarName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.resourceadapter_not_initialized", rarName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        return activeResourceAdapter;
    }

    private ActiveResourceAdapter getActiveResourceAdapter(String rarName) throws ConnectorRuntimeException {
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(rarName);
        if (activeResourceAdapter == null) {
            this.ifSystemRarLoad(rarName);
            activeResourceAdapter = _registry.getActiveResourceAdapter(rarName);
        }
        return activeResourceAdapter;
    }

    public ManagedConnectionFactory[] obtainManagedConnectionFactories(PoolInfo poolInfo) throws ConnectorRuntimeException {
        ManagedConnectionFactory[] mcfs = null;
        String raName = null;
        try {
            ConnectorConnectionPool conPool = this.getConnectorConnectionPool(poolInfo);
            ActiveResourceAdapter activeResourceAdapter = this.getResourceAdapter(conPool);
            raName = activeResourceAdapter.getModuleName();
            mcfs = activeResourceAdapter.createManagedConnectionFactories(conPool, null);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException("This pool is not bound in JNDI: " + String.valueOf(poolInfo), (Throwable)ne);
        }
        catch (NullPointerException ne) {
            String i18nMsg = I18N.getString("ccp_adm.failed_to_register_mcf", (Object)poolInfo);
            throw new ConnectorRuntimeException(i18nMsg, (Throwable)ne);
        }
        for (ManagedConnectionFactory mcf : mcfs) {
            this.validateMCF(mcf, raName);
        }
        return mcfs;
    }

    private void validateMCF(ManagedConnectionFactory mcf, String raName) {
        this._runtime.getConnectorBeanValidator().validateJavaBean(mcf, raName);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.obtainManagedConnectionFactory(poolInfo, null);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(PoolInfo poolInfo, Hashtable env) throws ConnectorRuntimeException {
        _logger.log(Level.FINE, "obtainManagedConnectionFactory(poolInfo={0}, env)", poolInfo);
        try {
            ClassLoader loader;
            if (_registry.isMCFCreated(poolInfo)) {
                return _registry.getManagedConnectionFactory(poolInfo);
            }
            ConnectorConnectionPool connectorConnectionPool = this.getConnectorConnectionPool(poolInfo, env);
            ActiveResourceAdapter activeResourceAdapter = this.getResourceAdapter(connectorConnectionPool);
            ManagedConnectionFactory mcf = activeResourceAdapter.createManagedConnectionFactory(connectorConnectionPool, loader = activeResourceAdapter.getClassLoader());
            if (mcf != null) {
                String str;
                this.validateMCF(mcf, activeResourceAdapter.getModuleName());
                ResourcePrincipalDescriptor prin = this.getDefaultResourcePrincipal(poolInfo, mcf, env);
                Subject s = ConnectionPoolObjectsUtils.createSubject(mcf, prin);
                int txSupport = connectorConnectionPool.getTransactionSupport();
                if (mcf instanceof TransactionSupport) {
                    TransactionSupport.TransactionSupportLevel mcfTS = ((TransactionSupport)mcf).getTransactionSupport();
                    int containerTxSupport = ConnectionPoolObjectsUtils.convertSpecTxSupportToContainerTxSupport(mcfTS);
                    boolean isValidTxSupportLevel = ConnectionPoolObjectsUtils.isTxSupportConfigurationSane(containerTxSupport, activeResourceAdapter.getModuleName());
                    if (isValidTxSupportLevel) {
                        txSupport = containerTxSupport;
                    } else {
                        Object[] params = new Object[]{mcfTS, activeResourceAdapter.getModuleName()};
                        String i18nMsg = I18N.getString("ccp_adm_service.incorrect_tx_support", params);
                        ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
                        _logger.log(Level.SEVERE, "rardeployment.incorrect_tx_support", connectorConnectionPool.getName());
                        throw cre;
                    }
                }
                boolean isPM = connectorConnectionPool.isNonComponent();
                boolean isNonTx = connectorConnectionPool.isNonTransactional();
                ConnectorSecurityMap[] securityMaps = connectorConnectionPool.getSecurityMaps();
                RuntimeSecurityMap runtimeSecurityMap = SecurityMapUtils.processSecurityMaps(securityMaps);
                boolean lazyEnlistable = connectorConnectionPool.isLazyConnectionEnlist();
                boolean lazyAssoc = connectorConnectionPool.isLazyConnectionAssoc();
                if (isPM || isNonTx) {
                    lazyEnlistable = false;
                }
                if (isPM && lazyAssoc && (str = System.getProperty("com.sun.enterprise.resource.AllowLazyAssociationWithPM", "FALSE")).toUpperCase(Locale.getDefault()).trim().equals("FALSE")) {
                    lazyAssoc = false;
                }
                PoolMetaData pmd = new PoolMetaData(poolInfo, mcf, s, txSupport, prin, isPM, isNonTx, lazyEnlistable, runtimeSecurityMap, lazyAssoc);
                _logger.log(Level.FINE, "Adding metadata: {0}", pmd);
                _registry.addManagedConnectionFactory(poolInfo, pmd);
            }
            ConnectorConstants.PoolType pt = this.getPoolType(connectorConnectionPool);
            this.createAndAddPool(poolInfo, pt, env);
            return mcf;
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException("This pool is not bound in JNDI: " + String.valueOf(poolInfo), (Throwable)ne);
        }
        catch (NullPointerException ne) {
            String i18nMsg = I18N.getString("ccp_adm.failed_to_register_mcf", (Object)poolInfo);
            throw new ConnectorRuntimeException(i18nMsg, (Throwable)ne);
        }
    }

    private ConnectorConstants.PoolType getPoolType(ConnectorConnectionPool connectorConnectionPool) {
        ConnectorConstants.PoolType pt = ConnectorConstants.PoolType.STANDARD_POOL;
        if (!connectorConnectionPool.isPoolingOn()) {
            pt = ConnectorConstants.PoolType.POOLING_DISABLED;
        } else if (connectorConnectionPool.isAssociateWithThread()) {
            pt = ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL;
        } else if (connectorConnectionPool.isPartitionedPool()) {
            pt = ConnectorConstants.PoolType.PARTITIONED_POOL;
        }
        return pt;
    }

    public ConnectorConstants.PoolType getPoolType(PoolInfo poolInfo) throws ConnectorRuntimeException {
        ConnectorConnectionPool ccp;
        try {
            ccp = this.getConnectorConnectionPool(poolInfo);
        }
        catch (NamingException e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
        return this.getPoolType(ccp);
    }

    private void createAndAddPool(PoolInfo poolInfo, ConnectorConstants.PoolType pt, Hashtable env) throws ConnectorRuntimeException {
        _logger.log(Level.FINE, "createAndAddPool(poolInfo={0}, pt, env)", poolInfo);
        PoolManager poolMgr = this._runtime.getPoolManager();
        try {
            poolMgr.createEmptyConnectionPool(poolInfo, pt, env);
        }
        catch (PoolingException pe) {
            String i18nMsg = I18N.getString("ccp_adm.failed_to_create_pool_object");
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)pe);
            throw cre;
        }
    }

    public boolean isConnectorConnectionPoolDeployed(PoolInfo poolInfo) {
        try {
            SimpleJndiName jndiName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
            this._runtime.getResourceNamingService().lookup((GenericResourceInfo)poolInfo, jndiName);
            return true;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        if (ccp == null) {
            throw new ConnectorRuntimeException("No pool to reconfigure, new pool object is null");
        }
        _logger.log(Level.FINE, "new ccp :\n{0}", ccp);
        PoolInfo poolInfo = ccp.getPoolInfo();
        ConnectorConnectionPool origCcp = null;
        try {
            origCcp = this.getOriginalConnectorConnectionPool(poolInfo);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException(ne.getMessage());
        }
        if (origCcp == null) {
            throw new ConnectorRuntimeException("No pool to reconfigure, original pool object is null");
        }
        _logger.log(Level.FINE, "original ccp :\n{0}", origCcp);
        ConnectionPoolReconfigHelper.ReconfigAction action = ConnectionPoolReconfigHelper.compare(origCcp, ccp, excludedProps);
        _logger.log(Level.FINE, "pool reconfig action == {0}", (Object)action);
        if (action == ConnectionPoolReconfigHelper.ReconfigAction.UPDATE_MCF_AND_ATTRIBUTES) {
            this.updateMCFAndPoolAttributes(ccp);
        } else if (action == ConnectionPoolReconfigHelper.ReconfigAction.RECREATE_POOL) {
            return true;
        }
        return false;
    }

    private void updateMCFAndPoolAttributes(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        PoolInfo poolInfo = ccp.getPoolInfo();
        try {
            ConnectorConnectionPool origCcp = this.getOriginalConnectorConnectionPool(poolInfo);
            origCcp.setSteadyPoolSize(ccp.getSteadyPoolSize());
            origCcp.setMaxPoolSize(ccp.getMaxPoolSize());
            origCcp.setMaxWaitTimeInMillis(ccp.getMaxWaitTimeInMillis());
            origCcp.setPoolResizeQuantity(ccp.getPoolResizeQuantity());
            origCcp.setIdleTimeoutInSeconds(ccp.getIdleTimeoutInSeconds());
            origCcp.setFailAllConnections(ccp.isFailAllConnections());
            origCcp.setMatchConnections(ccp.matchConnections());
            origCcp.setMaxConnectionUsage(ccp.getMaxConnectionUsage());
            origCcp.setNonComponent(ccp.isNonComponent());
            origCcp.setNonTransactional(ccp.isNonTransactional());
            origCcp.setConCreationRetryAttempts(ccp.getConCreationRetryAttempts());
            origCcp.setConCreationRetryInterval(ccp.getConCreationRetryInterval());
            origCcp.setValidateAtmostOncePeriod(ccp.getValidateAtmostOncePeriod());
            origCcp.setConnectionLeakTracingTimeout(ccp.getConnectionLeakTracingTimeout());
            origCcp.setConnectionReclaim(ccp.isConnectionReclaim());
            SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
            this._runtime.getResourceNamingService().unpublishObject((GenericResourceInfo)poolInfo, jndiNameForPool);
            this._runtime.getResourceNamingService().publishObject((GenericResourceInfo)poolInfo, jndiNameForPool, (Object)origCcp, true);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException(ne.getMessage());
        }
        PoolManager poolMgr = this._runtime.getPoolManager();
        try {
            poolMgr.reconfigPoolProperties(ccp);
        }
        catch (PoolingException pe) {
            throw new ConnectorRuntimeException(pe.getMessage());
        }
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        ManagedConnectionFactory mcf = registry.getManagedConnectionFactory(poolInfo);
        SetMethodAction<ConnectorConfigProperty> sma = new SetMethodAction<ConnectorConfigProperty>(mcf, ccp.getConnectorDescriptorInfo().getMCFConfigProperties());
        try {
            sma.run();
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
        PoolMetaData pmd = registry.getPoolMetaData(poolInfo);
        pmd.setIsPM(ccp.isNonComponent());
        pmd.setIsNonTx(ccp.isNonTransactional());
        pmd.setAuthCredentialsDefinedInPool(ccp.getAuthCredentialsDefinedInPool());
        _logger.fine("Pool properties reconfiguration done");
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        if (registry == null) {
            throw new ConnectorRuntimeException("Cannot get ConnectorRegistry");
        }
        PoolInfo poolInfo = ccp.getPoolInfo();
        this.unloadAndKillPool(poolInfo);
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        ManagedConnectionFactory mcf = null;
        try {
            this._runtime.getResourceNamingService().publishObject((GenericResourceInfo)poolInfo, jndiNameForPool, (Object)ccp, true);
            mcf = this.obtainManagedConnectionFactory(poolInfo);
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "rardeployment.pool_jndi_bind_failure", poolInfo);
            String i18nMsg = I18N.getString("ccp_adm.could_not_recreate_pool", (Object)poolInfo);
            throw new ConnectorRuntimeException(i18nMsg, (Throwable)ne);
        }
        finally {
            if (mcf == null) {
                try {
                    this._runtime.getResourceNamingService().unpublishObject((GenericResourceInfo)poolInfo, jndiNameForPool);
                }
                catch (NamingException e) {
                    _logger.log(Level.WARNING, "Unable to unbind the pool configuration object of pool [ " + String.valueOf(poolInfo) + " ] during MCF creation failure");
                }
                _logger.log(Level.WARNING, "rardeployment.mcf_creation_failure", poolInfo);
                String i18nMsg = I18N.getString("ccp_adm.failed_to_create_mcf", (Object)poolInfo);
                throw new ConnectorRuntimeException(i18nMsg);
            }
        }
    }

    private void unloadAndKillPool(PoolInfo poolInfo) throws ConnectorRuntimeException {
        this.killPool(poolInfo);
        boolean result = _registry.removeManagedConnectionFactory(poolInfo);
        if (!result) {
            _logger.log(Level.SEVERE, "Failed to remove the MCF {0}", poolInfo);
            String i18nMsg = I18N.getString("ccp_adm.wrong_params_for_create", (Object)poolInfo);
            throw new ConnectorRuntimeException(i18nMsg);
        }
        try {
            SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
            this._runtime.getResourceNamingService().unpublishObject((GenericResourceInfo)poolInfo, jndiNameForPool);
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_removal_from_jndi_error", poolInfo);
            String i18nMsg = I18N.getString("ccp_adm.failed_to_remove_from_jndi", (Object)poolInfo);
            throw new ConnectorRuntimeException(i18nMsg, (Throwable)ne);
        }
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        if (ccp == null || connectionDefinitionName == null || rarName == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = I18N.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        this.createConnectorConnectionPool(ccp);
    }

    public boolean flushConnectionPool(PoolInfo poolInfo) throws ConnectorRuntimeException {
        PoolManager poolMgr = this._runtime.getPoolManager();
        try {
            return poolMgr.flushConnectionPool(poolInfo);
        }
        catch (PoolingException ex) {
            throw new ConnectorRuntimeException("Flushing the connection pool " + String.valueOf(poolInfo.getName()) + " failed.", (Throwable)ex);
        }
    }

    public Connection getConnection(ResourceInfo resourceInfo, String user, String password) throws SQLException {
        try {
            PoolInfo poolInfo = this.getPoolInfo(resourceInfo);
            if (poolInfo == null) {
                throw new SQLException("No pool found for resource name " + String.valueOf(resourceInfo.getName()));
            }
            _logger.log(Level.FINE, "ConnectorRuntime.getConnection :: poolName  {0}", poolInfo.getName());
            String passwd = password == null ? "" : password;
            ResourcePrincipalDescriptor prin = user == null ? null : new ResourcePrincipalDescriptor(user, passwd);
            Connection con = (Connection)this.getUnpooledConnection(poolInfo, prin, true);
            if (con == null) {
                throw new SQLException(I18N.getString("ccp_adm.null_unpooled_connection"));
            }
            return con;
        }
        catch (SQLException e) {
            _logger.log(Level.WARNING, "Error allocating connection: [{0}]", e.getMessage());
            _logger.log(Level.FINE, "The getConnection failed.", e);
            throw e;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Error allocating connection: [{0}]", e.getMessage());
            _logger.log(Level.FINE, "The getConnection failed.", e);
            throw new SQLException(e.getMessage(), e);
        }
    }

    public Connection getConnection(ResourceInfo resourceInfo) throws SQLException {
        try {
            PoolInfo poolInfo = this.getPoolInfo(resourceInfo);
            if (poolInfo == null) {
                throw new SQLException("No pool found for resource name " + String.valueOf(resourceInfo.getName()));
            }
            _logger.log(Level.FINE, "ConnectorRuntime.getConnection :: poolName  {0}", poolInfo.getName());
            Connection con = (Connection)this.getUnpooledConnection(poolInfo, null, true);
            if (con == null) {
                throw new SQLException(I18N.getString("ccp_adm.null_unpooled_connection"));
            }
            return con;
        }
        catch (SQLException e) {
            _logger.log(Level.WARNING, "Error allocating connection: [{0}]", e.getMessage());
            _logger.log(Level.FINE, "The getConnection failed.", e);
            throw e;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Error allocating connection: [{0}]", e.getMessage());
            _logger.log(Level.FINE, "The getConnection failed.", e);
            throw new SQLException(e.getMessage(), e);
        }
    }

    private PoolInfo getPoolInfo(ResourceInfo resourceInfo) {
        PoolInfo poolInfo = null;
        List extensions = Globals.getDefaultHabitat().getAllServices(ConnectorRuntimeExtension.class, new Annotation[0]);
        for (ConnectorRuntimeExtension extension : extensions) {
            poolInfo = extension.getPoolNameFromResourceJndiName(resourceInfo);
        }
        return poolInfo;
    }
}

