/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.ListIterator;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.CountingWriter;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJSourceFile;
import org.jboss.jdeparser.Indent;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.Token;
import org.jboss.jdeparser.Tokens;
import org.jboss.jdeparser.Tokens$;

class SourceFileWriter
implements Flushable,
Closeable {
    private final FormatPreferences format;
    private final CountingWriter countingWriter;
    private final StringBuilder lineBuffer = new StringBuilder();
    private final String lineSep;
    private final ArrayDeque<AbstractJType> thisTypeStack = new ArrayDeque();
    private final ArrayList<Indent> indentStack = new ArrayList();
    private final ListIterator<Indent> stackIterator = this.indentStack.listIterator(0);
    private final Indent nextIndent = new Indent(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addIndent(Indent next, FormatPreferences preferences, StringBuilder lineBuffer) {
            if (SourceFileWriter.this.stackIterator.hasPrevious()) {
                Indent n = (Indent)SourceFileWriter.this.stackIterator.previous();
                try {
                    n.addIndent(next, preferences, lineBuffer);
                }
                finally {
                    SourceFileWriter.this.stackIterator.next();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void escape(Indent next, StringBuilder b, int idx) {
            if (SourceFileWriter.this.stackIterator.hasPrevious()) {
                Indent n = (Indent)SourceFileWriter.this.stackIterator.previous();
                try {
                    n.escape(this, b, idx);
                }
                finally {
                    SourceFileWriter.this.stackIterator.next();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unescaped(Indent next, StringBuilder b, int idx) {
            if (SourceFileWriter.this.stackIterator.hasPrevious()) {
                Indent n = (Indent)SourceFileWriter.this.stackIterator.previous();
                try {
                    n.unescaped(this, b, idx);
                }
                finally {
                    SourceFileWriter.this.stackIterator.next();
                }
            }
        }
    };
    private Token state = Tokens.$START;
    private int spaceState;
    private ImplJSourceFile classFile;
    private static final int SS_NONE = 0;
    private static final int SS_NEEDED = 1;
    private static final int SS_ADDED = 2;
    private static final int SS_NEW_LINE = 3;
    private static final int SS_2_NEW_LINE = 4;

    SourceFileWriter(FormatPreferences format, Writer writer) {
        this.format = format;
        this.countingWriter = new CountingWriter(writer);
        this.lineSep = System.lineSeparator();
    }

    void nl() throws IOException {
        this.countingWriter.write(this.lineBuffer);
        this.countingWriter.write(this.lineSep);
        this.lineBuffer.setLength(0);
        this.spaceState = this.spaceState == 3 ? 4 : 3;
    }

    void sp() throws IOException {
        if (this.spaceState == 3 || this.spaceState == 4) {
            this.addIndent();
        } else if (this.spaceState != 2) {
            this.spaceState = 2;
            this.lineBuffer.append(' ');
        }
    }

    void ntsp() throws IOException {
        if (this.spaceState == 0) {
            this.spaceState = 1;
        }
    }

    int getLine() {
        return this.countingWriter.getLine();
    }

    int getColumn() {
        return this.countingWriter.getColumn();
    }

    void processSpacing() throws IOException {
        switch (this.spaceState) {
            case 3: 
            case 4: {
                this.nextIndent.addIndent(this.nextIndent, this.format, this.lineBuffer);
                this.spaceState = 2;
                break;
            }
            case 1: {
                this.sp();
            }
        }
    }

    void addIndent() throws IOException {
        assert (this.spaceState == 3 || this.spaceState == 4);
        this.nextIndent.addIndent(this.nextIndent, this.format, this.lineBuffer);
        this.spaceState = 2;
    }

    void writeEscaped(String item) throws IOException {
        this.processSpacing();
        int idx = this.lineBuffer.length();
        this.lineBuffer.append(item);
        this.nextIndent.escape(this.nextIndent, this.lineBuffer, idx);
        this.spaceState = 0;
    }

    void writeEscaped(char item) throws IOException {
        this.processSpacing();
        int idx = this.lineBuffer.length();
        this.lineBuffer.append(item);
        this.nextIndent.escape(this.nextIndent, this.lineBuffer, idx);
        this.spaceState = 0;
    }

    void writeUnescaped(String item) throws IOException {
        this.processSpacing();
        int idx = this.lineBuffer.length();
        this.lineBuffer.append(item);
        this.nextIndent.unescaped(this.nextIndent, this.lineBuffer, idx);
        this.spaceState = 0;
    }

    void writeUnescaped(char item) throws IOException {
        this.processSpacing();
        int idx = this.lineBuffer.length();
        this.lineBuffer.append(item);
        this.nextIndent.unescaped(this.nextIndent, this.lineBuffer, idx);
        this.spaceState = 0;
    }

    void write(FormatPreferences.Space rule) throws IOException {
        if (rule == null) {
            return;
        }
        if (this.format.getSpaceType(rule) == FormatPreferences.SpaceType.NEWLINE) {
            if (this.spaceState != 4) {
                this.nl();
            }
        } else if (this.format.getSpaceType(rule) == FormatPreferences.SpaceType.SPACE) {
            this.ntsp();
        }
    }

    void writeClass(String nameToWrite) throws IOException {
        this.processSpacing();
        this.addWordSpace();
        this.writeEscaped(nameToWrite);
        this.state = Tokens.$WORD;
        this.spaceState = 0;
    }

    void addWordSpace() throws IOException {
        if (this.state instanceof Tokens$.KW || this.state == Tokens.$WORD || this.state == Tokens.$NUMBER) {
            this.ntsp();
        }
    }

    void write(Token state) throws IOException {
        this.processSpacing();
        state.write(this);
        this.state = state;
        this.spaceState = 0;
    }

    void writeEscapedWord(String rawText) throws IOException {
        this.writeEscaped(rawText);
        this.state = Tokens.$WORD;
    }

    @Override
    public void flush() throws IOException {
        this.countingWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.countingWriter.close();
    }

    void write(JType type) throws IOException {
        if (type != null) {
            AbstractJType.of(type).writeDirect(this);
        }
    }

    void write(AbstractJType type) throws IOException {
        if (type != null) {
            type.writeDirect(this);
        }
    }

    void write(JExpr expr) throws IOException {
        if (expr != null) {
            AbstractJExpr.of(expr).write(this);
        }
    }

    void write(AbstractJExpr expr) throws IOException {
        if (expr != null) {
            expr.write(this);
        }
    }

    void pushIndent(FormatPreferences.Indentation indentation) {
        this.pushIndent(indentation.getIndent());
    }

    void pushIndent(Indent indent) {
        this.stackIterator.add(indent);
    }

    void popIndent(FormatPreferences.Indentation indentation) {
        this.popIndent(indentation.getIndent());
    }

    void popIndent(Indent indent) {
        Indent pop = this.stackIterator.previous();
        this.stackIterator.remove();
        assert (pop == indent);
    }

    AbstractJType getThisType() {
        return this.thisTypeStack.peek();
    }

    void pushThisType(AbstractJType thisType) {
        this.thisTypeStack.push(thisType);
    }

    void popThisType(AbstractJType thisType) {
        AbstractJType pop = this.thisTypeStack.pop();
        assert (pop == thisType);
    }

    void setClassFile(ImplJSourceFile classFile) {
        this.classFile = classFile;
    }

    Token getState() {
        return this.state;
    }

    ImplJSourceFile getClassFile() {
        return this.classFile;
    }

    FormatPreferences getFormat() {
        return this.format;
    }
}

