/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IMarkSelection;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

class SelectionTracker {
    private final IViewPart targetview;
    private final StructuredViewer target;
    private boolean enabled = false;
    private IJavaElement currentSelection = null;
    private final ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part != SelectionTracker.this.targetview) {
                IJavaElement element;
                if (selection instanceof IStructuredSelection) {
                    IJavaElement element2;
                    IStructuredSelection ssel = (IStructuredSelection)selection;
                    if (ssel.size() == 1 && (element2 = SelectionTracker.this.getJavaElement(ssel.getFirstElement())) != null) {
                        SelectionTracker.this.applySelection(element2, false);
                    }
                    return;
                }
                if (part instanceof IEditorPart && (element = SelectionTracker.this.getJavaElement(((IEditorPart)part).getEditorInput())) != null) {
                    element = SelectionTracker.this.findElementAtCursor(element, selection);
                    SelectionTracker.this.applySelection(element, false);
                }
            }
        }
    };

    private IJavaElement getJavaElement(Object object) {
        if (object instanceof IJavaElement) {
            return (IJavaElement)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)object;
            return (IJavaElement)a.getAdapter(IJavaElement.class);
        }
        return null;
    }

    private IJavaElement findElementAtCursor(IJavaElement unit, ISelection selection) {
        int pos = -1;
        if (selection instanceof ITextSelection) {
            pos = ((ITextSelection)selection).getOffset();
        }
        if (selection instanceof IMarkSelection) {
            pos = ((IMarkSelection)selection).getOffset();
        }
        if (pos == -1) {
            return unit;
        }
        IJavaElement element = null;
        try {
            switch (unit.getElementType()) {
                case 5: {
                    element = ((ICompilationUnit)unit).getElementAt(pos);
                    break;
                }
                case 6: {
                    element = ((IClassFile)unit).getElementAt(pos);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return element == null ? unit : element;
    }

    private void applySelection(IJavaElement element, boolean force) {
        this.currentSelection = element;
        if (force || this.enabled && this.targetview != this.targetview.getSite().getPage().getActivePart()) {
            this.target.setSelection((ISelection)new StructuredSelection((Object)element), true);
        }
    }

    public SelectionTracker(IViewPart targetview, StructuredViewer target) {
        this.targetview = targetview;
        this.target = target;
        targetview.getSite().getPage().addPostSelectionListener(this.listener);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled && this.currentSelection != null) {
            this.applySelection(this.currentSelection, true);
        }
    }

    public void dispose() {
        this.targetview.getSite().getPage().removePostSelectionListener(this.listener);
    }
}

