/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.UISession;

public class ContextProvider {
    private static final ThreadLocal<ServiceContext> CONTEXT_HOLDER = new ThreadLocal();
    private static final Map<Thread, ServiceContext> CONTEXT_HOLDER_FOR_BG_THREADS = new WeakHashMap<Thread, ServiceContext>();

    public static void setContext(ServiceContext context) {
        ParamCheck.notNull(context, "context");
        if (ContextProvider.getContextInternal() != null) {
            String msg = "Current thread has already a context instance buffered.";
            throw new IllegalStateException(msg);
        }
        CONTEXT_HOLDER.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContext(ServiceContext context, Thread thread) {
        ParamCheck.notNull(context, "context");
        ParamCheck.notNull(thread, "thread");
        Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
        synchronized (map) {
            if (CONTEXT_HOLDER_FOR_BG_THREADS.containsKey(thread)) {
                String msg = "The given thread has already a context instance mapped.";
                throw new IllegalStateException(msg);
            }
            CONTEXT_HOLDER_FOR_BG_THREADS.put(thread, context);
        }
    }

    public static ServiceContext getContext() {
        ServiceContext result = ContextProvider.getContextInternal();
        if (result == null) {
            String msg = "No context available outside of the request processing.";
            throw new IllegalStateException(msg);
        }
        return result;
    }

    public static boolean hasContext() {
        return ContextProvider.getContextInternal() != null;
    }

    public static void disposeContext() {
        ServiceContext context = CONTEXT_HOLDER.get();
        if (context != null && !context.isDisposed()) {
            context.dispose();
        }
        ContextProvider.releaseContextHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeContext(Thread thread) {
        ParamCheck.notNull(thread, "thread");
        Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
        synchronized (map) {
            ServiceContext toRemove = CONTEXT_HOLDER_FOR_BG_THREADS.get(thread);
            if (toRemove != null) {
                CONTEXT_HOLDER_FOR_BG_THREADS.remove(thread);
                toRemove.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseContextHolder() {
        boolean result = false;
        ServiceContext object = CONTEXT_HOLDER.get();
        if (object != null) {
            CONTEXT_HOLDER.set(null);
        } else {
            Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
            synchronized (map) {
                ServiceContext toRemove = CONTEXT_HOLDER_FOR_BG_THREADS.get(Thread.currentThread());
                if (toRemove != null) {
                    CONTEXT_HOLDER_FOR_BG_THREADS.remove(Thread.currentThread());
                }
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceContext getContextInternal() {
        ServiceContext result = CONTEXT_HOLDER.get();
        if (result == null) {
            Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
            synchronized (map) {
                result = CONTEXT_HOLDER_FOR_BG_THREADS.get(Thread.currentThread());
            }
        }
        return result;
    }

    public static UISession getUISession() {
        return ContextProvider.getContext().getUISession();
    }

    public static ApplicationContextImpl getApplicationContext() {
        return ContextProvider.getContext().getApplicationContext();
    }

    public static HttpServletRequest getRequest() {
        return ContextProvider.getContext().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ContextProvider.getContext().getResponse();
    }

    public static ServiceStore getServiceStore() {
        return ContextProvider.getContext().getServiceStore();
    }

    public static ProtocolMessageWriter getProtocolWriter() {
        return ContextProvider.getContext().getProtocolWriter();
    }
}

