/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IPreferencesInfo;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreferencesInfo
extends ProductObject
implements IPreferencesInfo {
    private static final long serialVersionUID = 1L;
    private String fSourceFilePath;
    private String fPreferenceCustomizationPath;
    private String fOverwrite;

    public PreferencesInfo(IProductModel model) {
        super(model);
    }

    @Override
    public void setSourceFilePath(String text) {
        String old = this.fSourceFilePath;
        this.fSourceFilePath = text;
        if (this.isEditable()) {
            if (old != null && text != null) {
                if (!old.equals(text)) {
                    this.firePropertyChanged("sourcefilepath", old, this.fSourceFilePath);
                }
            } else if (old != text) {
                this.firePropertyChanged("sourcefilepath", old, this.fSourceFilePath);
            }
        }
    }

    @Override
    public String getSourceFilePath() {
        return this.fSourceFilePath;
    }

    @Override
    public void setOverwrite(String text) {
        String old = this.fOverwrite;
        this.fOverwrite = text;
        if (this.isEditable()) {
            if (old != null && text != null) {
                if (!old.equals(text)) {
                    this.firePropertyChanged("overwrite", old, this.fOverwrite);
                }
            } else if (old != text) {
                this.firePropertyChanged("overwrite", old, this.fOverwrite);
            }
        }
    }

    @Override
    public String getOverwrite() {
        return this.fOverwrite;
    }

    @Override
    public void setPreferenceCustomizationPath(String text) {
        String old = this.fPreferenceCustomizationPath;
        this.fPreferenceCustomizationPath = text;
        if (this.isEditable()) {
            if (old != null && text != null) {
                if (!old.equals(text)) {
                    this.firePropertyChanged("targetfilepath", old, this.fPreferenceCustomizationPath);
                }
            } else if (old != text) {
                this.firePropertyChanged("targetfilepath", old, this.fPreferenceCustomizationPath);
            }
        }
    }

    @Override
    public String getPreferenceCustomizationPath() {
        return this.fPreferenceCustomizationPath;
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<preferencesInfo>");
        if (this.fSourceFilePath != null && this.fSourceFilePath.length() > 0) {
            writer.println(String.valueOf(indent) + "   <sourcefile path=\"" + this.getWritableString(this.fSourceFilePath.trim()) + "\"/>");
        }
        boolean overwrite = this.fOverwrite != null && "true".equals(this.fOverwrite);
        String targetFile = String.valueOf(indent) + "   <targetfile overwrite=\"" + overwrite + "\"";
        if (this.fPreferenceCustomizationPath != null && this.fPreferenceCustomizationPath.length() > 0) {
            targetFile = String.valueOf(targetFile) + " path=\"" + this.getWritableString(this.fPreferenceCustomizationPath.trim()) + "\"";
        }
        targetFile = String.valueOf(targetFile) + "/>";
        writer.println(targetFile);
        writer.println(String.valueOf(indent) + "</preferencesInfo>");
    }

    @Override
    public void parse(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("sourcefile")) {
                    this.fSourceFilePath = ((Element)child).getAttribute("path");
                    if (this.fSourceFilePath.length() == 0) {
                        this.fSourceFilePath = null;
                    }
                } else if (child.getNodeName().equals("targetfile")) {
                    this.fOverwrite = ((Element)child).getAttribute("overwrite");
                    this.fPreferenceCustomizationPath = ((Element)child).getAttribute("path");
                    if (this.fPreferenceCustomizationPath.length() == 0) {
                        this.fPreferenceCustomizationPath = null;
                    }
                }
            }
            ++i;
        }
    }
}

