/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.EnvConfig;
import org.eclipse.comma.petrinet.Petrinet;
import org.eclipse.comma.petrinet.PythonPFCConverter;
import org.eclipse.comma.petrinet.PythonSBFCConverter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.scoping.IScopeProvider;

public class PetrinetBuilder {
    public static String forComponent(Component component, List<EnvConfig> environment, IScopeProvider scopeProvider, Mode mode) {
        List allInterfaces = ComponentUtilities.getAllInterfaces((EObject)component.eContainer(), (IScopeProvider)scopeProvider);
        ArrayList<String> nets = new ArrayList<String>();
        ArrayList<String> netsCode = new ArrayList<String>();
        for (EnvConfig connection : environment) {
            Interface itf = allInterfaces.stream().filter(i -> InterfaceUtilities.getSignature((Interface)i, (IScopeProvider)scopeProvider) == envConfig.port.getInterface()).findFirst().get();
            Petrinet.ParameterPlaceMode parameterPlaceMode = null;
            parameterPlaceMode = mode == Mode.INTERACTIVE ? (connection.port instanceof RequiredPort ? Petrinet.ParameterPlaceMode.TRIGGERED_EMPTY_NONTRIGGERED_NONE : Petrinet.ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY) : Petrinet.ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_NONE;
            PortDirection portDirection = connection.port instanceof RequiredPort ? PortDirection.REQUIRED : PortDirection.PROVIDED;
            Petrinet net = new Petrinet(itf, connection.param, parameterPlaceMode, connection.port.getName(), connection.component, portDirection);
            netsCode.add(net.toPython("net_" + connection.component + "_" + connection.port.getName()));
            nets.add("('" + connection.port.getName() + "', '" + connection.component + "'): net_" + connection.component + "_" + connection.port.getName());
        }
        ArrayList<String> constraints = new ArrayList<String>();
        ArrayList<String> constrainsCode = new ArrayList<String>();
        if (component.getFunctionalConstraintsBlock() != null) {
            for (FunctionalConstraint constraint : component.getFunctionalConstraintsBlock().getFunctionalConstraints()) {
                StateBasedFunctionalConstraint c;
                if (constraint instanceof StateBasedFunctionalConstraint) {
                    c = (StateBasedFunctionalConstraint)constraint;
                    constrainsCode.add(PythonSBFCConverter.convert(c));
                    constraints.add(c.getName());
                    continue;
                }
                if (constraint instanceof PredicateFunctionalConstraint) {
                    c = (PredicateFunctionalConstraint)constraint;
                    constrainsCode.add(PythonPFCConverter.convert((PredicateFunctionalConstraint)c));
                    continue;
                }
                throw new RuntimeException("Not supported");
            }
        }
        return PetrinetBuilder.build(netsCode, nets, constrainsCode, constraints);
    }

    public static String forInterface(Interface itf, Parameters params, IScopeProvider scopeProvider, Mode mode) {
        ArrayList<String> nets = new ArrayList<String>();
        ArrayList<String> netsCode = new ArrayList<String>();
        Petrinet.ParameterPlaceMode parameterPlaceMode = null;
        parameterPlaceMode = mode == Mode.INTERACTIVE ? Petrinet.ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY : Petrinet.ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_NONE;
        Petrinet net = new Petrinet(itf, params, parameterPlaceMode, itf.getName(), "c", PortDirection.NONE);
        netsCode.add(net.toPython("net_" + itf.getName()));
        nets.add("('" + itf.getName() + "', 'c') : net_" + itf.getName());
        return PetrinetBuilder.build(netsCode, nets, new ArrayList<String>(), new ArrayList<String>());
    }

    private static String build(List<String> netsCode, List<String> nets, List<String> constraintsCode, List<String> constraints) {
        StringBuilder sb = new StringBuilder();
        sb.append("## net\n");
        sb.append("from snakes.nets import Transition, Place, Expression, Variable, PetriNet\n");
        sb.append("from typing import Tuple\n\n");
        netsCode.forEach(c -> {
            StringBuilder stringBuilder2 = sb.append(String.valueOf(c) + "\n\n");
        });
        constraintsCode.forEach(c -> {
            StringBuilder stringBuilder2 = sb.append(String.valueOf(c) + "\n\n");
        });
        sb.append("nets = {\n");
        nets.forEach(c -> {
            StringBuilder stringBuilder2 = sb.append(String.format("    %s,\n", c));
        });
        sb.append("}\n");
        sb.append("constraints = [\n");
        constraints.forEach(c -> {
            StringBuilder stringBuilder2 = sb.append(String.format("    %sConstraint,\n", c));
        });
        sb.append("]\n");
        return sb.toString();
    }

    public static String getModelCode() {
        return "## model.py\n" + PetrinetBuilder.getResourceText("/model.py") + "\n\n";
    }

    public static String getWalkerCode() {
        return "## walker.py\n" + PetrinetBuilder.getResourceText("/walker.py") + "\n\n";
    }

    public static String getReachabilityGraphCode() {
        return "## reachability_graph.py\n" + PetrinetBuilder.getResourceText("/reachability_graph.py") + "\n\n";
    }

    private static String getResourceText(String resource) {
        InputStream stream = PetrinetBuilder.class.getResourceAsStream(resource);
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }

    public static enum Mode {
        INTERACTIVE,
        NOT_INTERACTIVE;

    }

    public static enum PortDirection {
        NONE,
        REQUIRED,
        PROVIDED;

    }
}

