/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TagCompletionProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetDefinitionContentAssist;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.DelegateProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.model.LocationNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.Node;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;

public class TagCompletionProcessor
extends DelegateProcessor {
    private static final HashMap<String, String[]> tagChildren = new HashMap();
    private static final List<Class<? extends Node>> allowedDuplicatesTags = new ArrayList<Class<? extends Node>>();
    private String searchTerm;
    private int offset;

    static {
        tagChildren.put(null, new String[]{"target"});
        tagChildren.put("target", new String[]{"locations", "targetJRE", "launcherArgs", "environment"});
        tagChildren.put("environment", new String[]{"os", "ws", "arch", "nl"});
        tagChildren.put("launcherArgs", new String[]{"vmArgs", "programArgs"});
        tagChildren.put("locations", new String[]{"location (Installable Unit)", "location (Profile)", "location (Directory)", "location (Feature)"});
        tagChildren.put("location", new String[]{"unit", "repository"});
        allowedDuplicatesTags.add(LocationNode.class);
        allowedDuplicatesTags.add(UnitNode.class);
    }

    public TagCompletionProcessor(String searchTerm, String acKey, int offset) {
        this.searchTerm = searchTerm;
        this.offset = offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ICompletionProposal[] getCompletionProposals() {
        void var7_11;
        ArrayList<TagCompletionProposal> proposals = new ArrayList<TagCompletionProposal>();
        Object[] tags = null;
        Parser parser = Parser.getDefault();
        Node node = parser.getRootNode();
        List<Object> children = new ArrayList<Node>();
        if (node == null) {
            tags = tagChildren.get(null);
        } else if (!this.isOffsetWithinNode(node)) {
            children.add(node);
            tags = tagChildren.get(null);
        } else {
            children = node.getChildNodes();
            while (children != null && this.isOffsetWithinNode(node)) {
                Node selectedChildNode = null;
                for (Node node2 : children) {
                    if (!this.isOffsetWithinNode(node2)) continue;
                    selectedChildNode = node2;
                    children = selectedChildNode.getChildNodes();
                    break;
                }
                if (selectedChildNode == null) break;
                node = selectedChildNode;
                if (!tagChildren.containsKey(selectedChildNode.getNodeTag())) break;
            }
            if (tagChildren.containsKey(node.getNodeTag())) {
                tags = tagChildren.get(node.getNodeTag());
            } else if (node.getParentNode() != null && tagChildren.containsKey(node.getParentNode().getNodeTag())) {
                tags = tagChildren.get(node.getParentNode().getNodeTag());
                children = node.getParentNode().getChildNodes();
            } else {
                tags = tagChildren.get(null);
            }
        }
        ArrayList<String> siblingTags = new ArrayList<String>();
        if (children != null) {
            for (Node node3 : children) {
                if (allowedDuplicatesTags.contains(node3.getClass())) continue;
                siblingTags.add(node3.getNodeTag());
            }
        }
        Arrays.sort(tags);
        boolean bl = false;
        while (var7_11 < tags.length) {
            StyledString displayString = TargetDefinitionContentAssist.getFilteredStyledString((String)tags[var7_11], this.searchTerm);
            if (displayString != null && displayString.length() != 0 && !siblingTags.contains(tags[var7_11])) {
                proposals.add(new TagCompletionProposal((String)tags[var7_11], this.offset - this.searchTerm.length(), this.searchTerm.length(), displayString));
            }
            ++var7_11;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean isOffsetWithinNode(Node node) {
        return node != null && this.offset <= node.getOffsetEnd() && this.offset > node.getOffsetStart();
    }
}

