/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.template.IProjectGenerator;

@Beta
public class DefaultTemplateProjectCreator
extends WorkspaceModifyOperation
implements IProjectCreator,
IProjectGenerator {
    private IProjectInfo projectInfo;
    private final List<ProjectFactory> projectFactories = new ArrayList<ProjectFactory>();

    @Override
    public IFile getResult() {
        return null;
    }

    @Override
    public void setProjectInfo(IProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    protected IProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    @Override
    public void generate(ProjectFactory project) {
        this.projectFactories.add(project);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.projectFactories.size());
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            for (ProjectFactory projectFactory : this.projectFactories) {
                projectFactory.setWorkbench(workbench);
                projectFactory.setWorkspace(workspace);
                projectFactory.createProject((IProgressMonitor)subMonitor, null);
                subMonitor.worked(1);
            }
        }
        finally {
            subMonitor.done();
        }
    }
}

