/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;

public class ZipFileStructureCreator
implements IStructureCreator {
    private String fTitle;

    public ZipFileStructureCreator() {
        this(Utilities.getString("ZipStructureCreator.name"));
    }

    public ZipFileStructureCreator(String title) {
        this.fTitle = title;
    }

    @Override
    public String getName() {
        return this.fTitle;
    }

    @Override
    public IStructureComparator getStructure(Object input) {
        InputStream is = null;
        if (input instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)input;
            try {
                is = sca.getContents();
            }
            catch (CoreException coreException) {}
        }
        if (is == null) {
            return null;
        }
        ZipInputStream zip = new ZipInputStream(is);
        ZipFolder root = new ZipFolder("");
        try {
            try {
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    ZipFile ze = root.createContainer(entry.getName());
                    if (ze != null) {
                        byte[] buffer;
                        int length = (int)entry.getSize();
                        if (length >= 0) {
                            int n;
                            buffer = new byte[length];
                            int offset = 0;
                            do {
                                n = zip.read(buffer, offset, length);
                                offset += n;
                            } while ((length -= n) > 0);
                            ze.setBytes(buffer);
                        } else {
                            int n;
                            buffer = new byte[1024];
                            do {
                                n = zip.read(buffer, 0, 1024);
                                ze.appendBytes(buffer, n);
                            } while (n >= 0);
                        }
                    }
                    zip.closeEntry();
                }
            }
            catch (IOException iOException) {
                try {
                    zip.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
        if (root.fChildren.size() == 1) {
            Iterator<ZipResource> iter = root.fChildren.values().iterator();
            return iter.next();
        }
        return root;
    }

    @Override
    public String getContents(Object o, boolean ignoreWhitespace) {
        if (o instanceof ZipFile) {
            byte[] bytes = ((ZipFile)o).getBytes();
            if (bytes != null) {
                return new String(bytes);
            }
            return "";
        }
        return null;
    }

    public boolean canSave() {
        return false;
    }

    @Override
    public void save(IStructureComparator structure, Object input) {
        Assert.isTrue((boolean)false);
    }

    @Override
    public IStructureComparator locate(Object path, Object source) {
        return null;
    }

    public boolean canRewriteTree() {
        return false;
    }

    public void rewriteTree(Differencer differencer, IDiffContainer root) {
    }

    static class ZipFile
    extends ZipResource
    implements IStreamContentAccessor {
        private byte[] fContents;

        ZipFile(String name) {
            super(name);
        }

        @Override
        public String getType() {
            String s = this.getName();
            int pos = s.lastIndexOf(46);
            if (pos >= 0) {
                return s.substring(pos + 1);
            }
            return "???";
        }

        @Override
        public Object[] getChildren() {
            return null;
        }

        @Override
        public InputStream getContents() {
            if (this.fContents == null) {
                this.fContents = new byte[0];
            }
            return new ByteArrayInputStream(this.fContents);
        }

        byte[] getBytes() {
            return this.fContents;
        }

        void setBytes(byte[] buffer) {
            this.fContents = buffer;
        }

        void appendBytes(byte[] buffer, int length) {
            if (length > 0) {
                int oldLen = 0;
                if (this.fContents != null) {
                    oldLen = this.fContents.length;
                }
                byte[] newBuf = new byte[oldLen + length];
                if (oldLen > 0) {
                    System.arraycopy(this.fContents, 0, newBuf, 0, oldLen);
                }
                System.arraycopy(buffer, 0, newBuf, oldLen, length);
                this.fContents = newBuf;
            }
        }
    }

    static class ZipFolder
    extends ZipResource {
        private HashMap<String, ZipResource> fChildren = new HashMap(10);

        ZipFolder(String name) {
            super(name);
        }

        @Override
        public String getType() {
            return "FOLDER";
        }

        @Override
        public Object[] getChildren() {
            Object[] children = new Object[this.fChildren.size()];
            Iterator<ZipResource> iter = this.fChildren.values().iterator();
            int i = 0;
            while (iter.hasNext()) {
                children[i] = iter.next();
                ++i;
            }
            return children;
        }

        ZipFile createContainer(String path) {
            ZipResource o;
            String entry = path;
            int pos = path.indexOf(47);
            if (pos < 0) {
                pos = path.indexOf(92);
            }
            if (pos < 0) {
                if (entry.length() > 0) {
                    if (CompareUIPlugin.getDefault().filter(path, false, true)) {
                        return null;
                    }
                    ZipFile ze = new ZipFile(entry);
                    this.fChildren.put(entry, ze);
                    return ze;
                }
                return null;
            }
            entry = path.substring(0, pos);
            path = path.substring(pos + 1);
            ZipFolder folder = null;
            if (this.fChildren != null && (o = this.fChildren.get(entry)) instanceof ZipFolder) {
                folder = (ZipFolder)o;
            }
            if (folder == null) {
                if (path.length() > 0 && CompareUIPlugin.getDefault().filter(path, true, true)) {
                    return null;
                }
                folder = new ZipFolder(entry);
                this.fChildren.put(entry, folder);
            }
            return folder.createContainer(path);
        }
    }

    static abstract class ZipResource
    implements IStructureComparator,
    ITypedElement {
        private String fName;

        ZipResource(String name) {
            this.fName = name;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Image getImage() {
            return CompareUI.getImage(this.getType());
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ITypedElement) {
                return this.fName.equals(((ITypedElement)other).getName());
            }
            return super.equals(other);
        }

        public int hashCode() {
            return this.fName.hashCode();
        }
    }
}

