/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.obeonetwork.m2doc.parser.BodyElementIterator;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.obeonetwork.m2doc.parser.RunIterator;

public class TokenIterator
implements Iterator<ParsingToken> {
    private Iterator<IBodyElement> elementIterator;
    private Iterator<ParsingToken> tokenIterator;

    public TokenIterator(IBody inputBody) {
        if (inputBody == null) {
            throw new IllegalArgumentException("Input documnet shouldn't be null");
        }
        this.elementIterator = inputBody.getBodyElements().iterator();
    }

    private void moveToNextToken() {
        if (this.tokenIterator == null || !this.tokenIterator.hasNext()) {
            while (this.elementIterator.hasNext() && (this.tokenIterator == null || !this.tokenIterator.hasNext())) {
                IBodyElement element = this.elementIterator.next();
                switch (element.getElementType()) {
                    case PARAGRAPH: {
                        XWPFParagraph paragraph = (XWPFParagraph)element;
                        if (paragraph.getRuns().size() == 0) {
                            paragraph.createRun().setText("");
                        }
                        this.tokenIterator = new RunIterator(((XWPFParagraph)element).getRuns());
                        break;
                    }
                    case TABLE: {
                        this.tokenIterator = new BodyElementIterator(element);
                        break;
                    }
                    case CONTENTCONTROL: {
                        this.tokenIterator = new BodyElementIterator(element);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported type of body element : " + element.getElementType());
                    }
                }
            }
        }
    }

    @Override
    public ParsingToken next() {
        this.moveToNextToken();
        if (this.tokenIterator != null && this.tokenIterator.hasNext()) {
            return this.tokenIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        this.moveToNextToken();
        return this.tokenIterator != null && this.tokenIterator.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

