/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.genericeditor.AutoEditStrategyRegistry;
import org.eclipse.ui.internal.genericeditor.CompositeQuickAssistProcessor;
import org.eclipse.ui.internal.genericeditor.CompositeReconciler;
import org.eclipse.ui.internal.genericeditor.ContentAssistProcessorRegistry;
import org.eclipse.ui.internal.genericeditor.ContentTypeRelatedExtensionTracker;
import org.eclipse.ui.internal.genericeditor.DefaultWordHighlightReconciler;
import org.eclipse.ui.internal.genericeditor.GenericEditorContentAssistant;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.PresentationReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.ReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.folding.DefaultFoldingReconciler;
import org.eclipse.ui.internal.genericeditor.hover.CompositeTextHover;
import org.eclipse.ui.internal.genericeditor.markers.MarkerResoltionQuickAssistProcessor;
import org.eclipse.ui.texteditor.ITextEditor;

public final class ExtensionBasedTextViewerConfiguration
extends TextSourceViewerConfiguration
implements IDocumentPartitioningListener {
    private ITextEditor editor;
    private Set<IContentType> contentTypes;
    private IDocument document;
    private GenericEditorContentAssistant contentAssistant;

    public ExtensionBasedTextViewerConfiguration(ITextEditor editor, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.editor = editor;
    }

    Set<IContentType> getContentTypes(ITextViewer viewer) {
        if (this.contentTypes == null) {
            this.contentTypes = new LinkedHashSet<IContentType>();
            String fileName = null;
            fileName = this.getCurrentFileName(viewer);
            if (fileName == null) {
                return Collections.emptySet();
            }
            LinkedList<IContentType> types = new LinkedList<IContentType>(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(fileName)));
            while (!types.isEmpty()) {
                IContentType type = (IContentType)types.poll();
                this.contentTypes.add(type);
                IContentType parent = type.getBaseType();
                if (parent == null) continue;
                types.add(parent);
            }
        }
        return this.contentTypes;
    }

    private String getCurrentFileName(ITextViewer viewer) {
        ITextFileBuffer buffer;
        IDocument viewerDocument;
        String fileName = null;
        if (this.editor != null) {
            fileName = this.editor.getEditorInput().getName();
        }
        if (fileName == null && (viewerDocument = viewer.getDocument()) != null && (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(viewerDocument)) != null) {
            fileName = buffer.getLocation().lastSegment();
        }
        return fileName;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        List<ITextHover> hovers = GenericEditorPlugin.getDefault().getHoverRegistry().getAvailableHovers(sourceViewer, this.editor, this.getContentTypes((ITextViewer)sourceViewer));
        if (hovers == null || hovers.isEmpty()) {
            return null;
        }
        if (hovers.size() == 1) {
            return hovers.get(0);
        }
        return new CompositeTextHover(hovers);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistProcessorRegistry registry = GenericEditorPlugin.getDefault().getContentAssistProcessorRegistry();
        ContentTypeRelatedExtensionTracker<IContentAssistProcessor> contentAssistProcessorTracker = new ContentTypeRelatedExtensionTracker<IContentAssistProcessor>(GenericEditorPlugin.getDefault().getBundle().getBundleContext(), IContentAssistProcessor.class, sourceViewer.getTextWidget().getDisplay());
        Set<IContentType> types = this.getContentTypes((ITextViewer)sourceViewer);
        this.contentAssistant = new GenericEditorContentAssistant(contentAssistProcessorTracker, registry.getContentAssistProcessors(sourceViewer, this.editor, types), types);
        if (this.document != null) {
            this.associateTokenContentTypes(this.document);
        }
        this.watchDocument(sourceViewer.getDocument());
        return this.contentAssistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconcilerRegistry registry = GenericEditorPlugin.getDefault().getPresentationReconcilerRegistry();
        List<IPresentationReconciler> reconciliers = registry.getPresentationReconcilers(sourceViewer, this.editor, this.getContentTypes((ITextViewer)sourceViewer));
        if (!reconciliers.isEmpty()) {
            return reconciliers.get(0);
        }
        return super.getPresentationReconciler(sourceViewer);
    }

    void watchDocument(IDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
        }
        if (document != null) {
            this.document = document;
            this.associateTokenContentTypes(document);
            document.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
        }
    }

    public void documentPartitioningChanged(IDocument document) {
        this.associateTokenContentTypes(document);
    }

    private void associateTokenContentTypes(IDocument document) {
        if (this.contentAssistant == null) {
            return;
        }
        this.contentAssistant.updateTokens(document);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant quickAssistAssistant = new QuickAssistAssistant();
        ArrayList<IQuickAssistProcessor> quickAssistProcessors = new ArrayList<IQuickAssistProcessor>();
        quickAssistProcessors.add(new MarkerResoltionQuickAssistProcessor());
        quickAssistProcessors.addAll(GenericEditorPlugin.getDefault().getQuickAssistProcessorRegistry().getQuickAssistProcessors(sourceViewer, this.editor, this.getContentTypes((ITextViewer)sourceViewer)));
        CompositeQuickAssistProcessor compQuickAssistProcessor = new CompositeQuickAssistProcessor(quickAssistProcessors);
        quickAssistAssistant.setQuickAssistProcessor((IQuickAssistProcessor)compQuickAssistProcessor);
        quickAssistAssistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        quickAssistAssistant.setInformationControlCreator(parent -> new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString()));
        return quickAssistAssistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ReconcilerRegistry registry = GenericEditorPlugin.getDefault().getReconcilerRegistry();
        List<IReconciler> reconcilers = registry.getReconcilers(sourceViewer, this.editor, this.getContentTypes((ITextViewer)sourceViewer));
        List<IReconciler> highlightReconcilers = registry.getHighlightReconcilers(sourceViewer, this.editor, this.getContentTypes((ITextViewer)sourceViewer));
        if (!highlightReconcilers.isEmpty()) {
            reconcilers.addAll(highlightReconcilers);
        } else {
            reconcilers.add((IReconciler)new DefaultWordHighlightReconciler());
        }
        List<IReconciler> foldingReconcilers = registry.getFoldingReconcilers(sourceViewer, this.editor, this.getContentTypes((ITextViewer)sourceViewer));
        if (!foldingReconcilers.isEmpty()) {
            reconcilers.addAll(foldingReconcilers);
        } else {
            reconcilers.add((IReconciler)new DefaultFoldingReconciler());
        }
        if (!reconcilers.isEmpty()) {
            return new CompositeReconciler(reconcilers);
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        AutoEditStrategyRegistry registry = GenericEditorPlugin.getDefault().getAutoEditStrategyRegistry();
        List<IAutoEditStrategy> editStrategies = registry.getAutoEditStrategies(sourceViewer, this.editor, this.getContentTypes((ITextViewer)sourceViewer));
        if (!editStrategies.isEmpty()) {
            return editStrategies.toArray(new IAutoEditStrategy[editStrategies.size()]);
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.ui.genericeditor.GenericEditor", this.editor);
        return targets;
    }
}

