/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.monitoring.lib.CPathDescription;

public class CFunctionalConstraintState
implements Serializable {
    protected Map<String, Map<String, CPathDescription>> portsStates;
    protected Map<String, Set<String>> initialPortStates;

    public Map<String, Map<String, CPathDescription>> get_commaVar_portsStates() {
        return this.portsStates;
    }

    public void set_commaVar_portsStates(Map<String, Map<String, CPathDescription>> m) {
        this.portsStates = m;
    }

    public boolean portInState(String port, String state, String contextPort, String contextConnection) {
        if (this.portsStates.containsKey(port)) {
            return this.allAtPortInState(port, new HashSet<String>(Arrays.asList(state)), contextPort, contextConnection);
        }
        return this.initialPortStates.get(port).contains(state);
    }

    public boolean allAtPortInState(String port, Set<String> states, String contextPort, String contextConnection) {
        if (!this.portsStates.containsKey(port)) {
            return true;
        }
        for (String connection : this.portsStates.get(port).keySet()) {
            Set<String> actualStates = port.equals(contextPort) && connection.equals(contextConnection) ? this.portsStates.get(port).get(connection).getActiveStates() : this.portsStates.get(port).get(connection).getPostEventStates();
            HashSet<String> intersection = new HashSet<String>(actualStates);
            intersection.retainAll(states);
            if (!intersection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean someAtPortInState(String port, Set<String> states, String contextPort, String contextConnection, int lower, int upper) {
        int count = 0;
        Map<String, CPathDescription> connectionsAtPort = this.portsStates.get(port);
        if (connectionsAtPort != null) {
            for (String connection : connectionsAtPort.keySet()) {
                Set<String> actualStates = port.equals(contextPort) && connection.equals(contextConnection) ? connectionsAtPort.get(connection).getActiveStates() : connectionsAtPort.get(connection).getPostEventStates();
                HashSet<String> intersection = new HashSet<String>(actualStates);
                intersection.retainAll(states);
                if (intersection.isEmpty()) continue;
                ++count;
            }
        }
        return upper != -1 ? lower <= count && count <= upper : lower <= count;
    }

    public boolean connectionAtPortInState(String connection, String port, Set<String> states, String contextPort, String contextConnection) {
        Map<String, CPathDescription> connectionsAtPort = this.portsStates.get(port);
        if (connectionsAtPort == null) {
            return false;
        }
        CPathDescription connectionInfo = connectionsAtPort.get(connection);
        if (connectionInfo == null) {
            return false;
        }
        Set<String> actualStates = port.equals(contextPort) && connection.equals(contextConnection) ? connectionInfo.getActiveStates() : connectionInfo.getPostEventStates();
        HashSet<String> intersection = new HashSet<String>(actualStates);
        intersection.retainAll(states);
        if (intersection.isEmpty()) {
            return false;
        }
        return !intersection.isEmpty();
    }
}

