/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.List;
import org.eclipse.comma.monitoring.lib.CExecutionContext;
import org.eclipse.comma.monitoring.lib.CInterfaceDecisionResult;
import org.eclipse.comma.monitoring.lib.CInterfaceDecisionResultKind;
import org.eclipse.comma.monitoring.lib.CState;
import org.eclipse.comma.monitoring.lib.constraints.CRule;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public abstract class CInterfaceDecisionClass {
    protected static CInterfaceDecisionResult noTransitions = new CInterfaceDecisionResult();
    protected static CInterfaceDecisionResult unknownEvent;

    static {
        CInterfaceDecisionClass.noTransitions.resutKind = CInterfaceDecisionResultKind.NO_TRANSITIONS;
        unknownEvent = new CInterfaceDecisionResult();
        CInterfaceDecisionClass.unknownEvent.resutKind = CInterfaceDecisionResultKind.RUNTIME_ERROR;
        CInterfaceDecisionClass.unknownEvent.errorMessage = "Unknown interface event";
    }

    public abstract void setState(CState var1);

    public abstract CInterfaceDecisionResult consume(CObservedMessage var1);

    public abstract List<CRule> getRules();

    protected void updateState(CState state, String currentState, String targetState, String clauseKey, CExecutionContext context) {
        state.setExecutionState(currentState);
        state.setActiveState(targetState);
        state.clauseEnacted(clauseKey);
        state.stateEnacted(targetState);
        context.setState((CState)Utils.deepCopy(state));
    }

    protected CInterfaceDecisionResult checkTransitionsResult(List<CExecutionContext> contexts) {
        if (!contexts.isEmpty()) {
            CInterfaceDecisionResult result = new CInterfaceDecisionResult();
            result.expectedObservations = contexts;
            return result;
        }
        return noTransitions;
    }
}

