/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class LaunchConfigurationBuildfileChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private String fNewBuildfileLocation;
    private String fNewProjectName;
    private String fNewLaunchConfigurationName;
    private String fOldBuildfileLocation;
    private String fOldProjectName;
    private ILaunchConfigurationWorkingCopy fNewLaunchConfiguration;
    private String fNewConfigContainerName;

    public static Change createChangesForProjectRename(IProject project, String newProjectName) throws CoreException {
        String projectName = project.getDescription().getName();
        ILaunchConfiguration[] configs = LaunchConfigurationBuildfileChange.getAntLaunchConfigurations();
        List<Change> changes = LaunchConfigurationBuildfileChange.createChangesForProjectRename(configs, projectName, newProjectName);
        return LaunchConfigurationBuildfileChange.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationBuildfileChange_7);
    }

    public static Change createChangesForBuildfileRename(IFile file, String newBuildfileName) throws CoreException {
        IContentDescription description = null;
        try {
            description = file.getContentDescription();
        }
        catch (CoreException coreException) {
            return null;
        }
        if (description == null) {
            return null;
        }
        IContentType contentType = description.getContentType();
        if (contentType == null || !"org.eclipse.ant.core.antBuildFile".equals(contentType.getId())) {
            return null;
        }
        ILaunchConfiguration[] configs = LaunchConfigurationBuildfileChange.getAntLaunchConfigurations();
        List<Change> changes = LaunchConfigurationBuildfileChange.createChangesForBuildfileRename(file, configs, file.getProject().getName(), newBuildfileName);
        return LaunchConfigurationBuildfileChange.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationBuildfileChange_7);
    }

    private static ILaunchConfiguration[] getAntLaunchConfigurations() throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        return configs;
    }

    private static Change createChangeFromList(List<Change> changes, String changeLabel) {
        int nbChanges = changes.size();
        if (nbChanges == 0) {
            return null;
        }
        if (nbChanges == 1) {
            return changes.get(0);
        }
        return new CompositeChange(changeLabel, changes.toArray(new Change[changes.size()]));
    }

    private static List<Change> createChangesForProjectRename(ILaunchConfiguration[] configs, String projectName, String newProjectName) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            String launchConfigurationProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName.equals(launchConfigurationProjectName)) {
                LaunchConfigurationBuildfileChange change = new LaunchConfigurationBuildfileChange(launchConfiguration, null, null, newProjectName, false);
                String newContainerName = LaunchConfigurationBuildfileChange.computeNewContainerName(launchConfiguration);
                if (newContainerName != null) {
                    change.setNewContainerName(newContainerName);
                }
                changes.add(change);
            }
            ++n2;
        }
        return changes;
    }

    private static List<Change> createChangesForBuildfileRename(IFile buildfile, ILaunchConfiguration[] configs, String projectName, String newBuildfileName) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            String launchConfigurationProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName.equals(launchConfigurationProjectName)) {
                LaunchConfigurationBuildfileChange change = new LaunchConfigurationBuildfileChange(launchConfiguration, buildfile.getName(), newBuildfileName, null, false);
                changes.add(change);
            }
            ++n2;
        }
        return changes;
    }

    protected void setNewContainerName(String newContainerName) {
        this.fNewConfigContainerName = newContainerName;
    }

    private static String computeNewContainerName(ILaunchConfiguration launchConfiguration) {
        IFile file = launchConfiguration.getFile();
        if (file != null) {
            return file.getParent().getProjectRelativePath().toString();
        }
        return null;
    }

    protected LaunchConfigurationBuildfileChange(ILaunchConfiguration launchConfiguration, String oldBuildFileName, String newBuildfileName, String newProjectName, boolean undo) throws CoreException {
        this.fLaunchConfiguration = launchConfiguration;
        this.fNewLaunchConfiguration = launchConfiguration.getWorkingCopy();
        this.fNewBuildfileLocation = newBuildfileName;
        this.fNewProjectName = newProjectName;
        this.fOldBuildfileLocation = oldBuildFileName;
        this.fOldProjectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (this.fNewBuildfileLocation != null) {
            String launchConfigurationName = this.fLaunchConfiguration.getName();
            this.fNewLaunchConfigurationName = launchConfigurationName.replaceAll(oldBuildFileName, newBuildfileName);
            if (launchConfigurationName.equals(this.fNewLaunchConfigurationName) || !undo && DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(this.fNewLaunchConfigurationName)) {
                this.fNewLaunchConfigurationName = null;
            }
        }
    }

    public String getName() {
        if (this.fNewLaunchConfigurationName != null) {
            return MessageFormat.format(RefactoringMessages.LaunchConfigurationBuildfileChange_0, this.fLaunchConfiguration.getName(), this.fNewLaunchConfigurationName);
        }
        if (this.fNewProjectName == null) {
            return MessageFormat.format(RefactoringMessages.LaunchConfigurationBuildfileChange_1, this.fLaunchConfiguration.getName());
        }
        return MessageFormat.format(RefactoringMessages.LaunchConfigurationBuildfileChange_2, this.fLaunchConfiguration.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fLaunchConfiguration.exists()) {
            String buildFileLocation = this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
            if (this.fOldBuildfileLocation == null || buildFileLocation.endsWith(String.valueOf(this.fOldBuildfileLocation) + '}') || buildFileLocation.endsWith(this.fOldBuildfileLocation)) {
                String projectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (this.fOldProjectName.equals(projectName)) {
                    return new RefactoringStatus();
                }
                return RefactoringStatus.createWarningStatus((String)MessageFormat.format(RefactoringMessages.LaunchConfigurationBuildfileChange_4, this.fLaunchConfiguration.getName(), this.fOldProjectName));
            }
            return RefactoringStatus.createWarningStatus((String)MessageFormat.format(RefactoringMessages.LaunchConfigurationBuildfileChange_5, this.fLaunchConfiguration.getName(), this.fOldBuildfileLocation));
        }
        return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringMessages.LaunchConfigurationBuildfileChange_6, this.fLaunchConfiguration.getName()));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String oldProjectName;
        String newBuildFileLocation;
        if (this.fNewConfigContainerName != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(this.fNewProjectName);
            IContainer container = (IContainer)project.findMember(this.fNewConfigContainerName);
            this.fNewLaunchConfiguration.setContainer(container);
        }
        String oldBuildfileLocation = this.fNewLaunchConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
        if (this.fNewBuildfileLocation != null) {
            newBuildFileLocation = oldBuildfileLocation.replaceFirst(this.fOldBuildfileLocation, this.fNewBuildfileLocation);
            this.fNewLaunchConfiguration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", newBuildFileLocation);
            this.fNewLaunchConfiguration.setMappedResources(new IResource[]{this.getAssociatedFile(newBuildFileLocation)});
        }
        if (this.fNewProjectName != null) {
            oldProjectName = this.fOldProjectName;
            this.fNewLaunchConfiguration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fNewProjectName);
            newBuildFileLocation = oldBuildfileLocation.replaceFirst(oldProjectName, this.fNewProjectName);
            this.fNewLaunchConfiguration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", newBuildFileLocation);
            this.fNewLaunchConfiguration.setMappedResources(new IResource[]{this.getAssociatedFile(newBuildFileLocation)});
            String launchConfigurationName = this.fLaunchConfiguration.getName();
            this.fNewLaunchConfigurationName = launchConfigurationName.replaceFirst(oldProjectName, this.fNewProjectName);
            if (launchConfigurationName.equals(this.fNewLaunchConfigurationName) || DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(this.fNewLaunchConfigurationName)) {
                this.fNewLaunchConfigurationName = null;
            }
        } else {
            oldProjectName = null;
        }
        if (this.fNewLaunchConfigurationName != null) {
            this.fNewLaunchConfiguration.rename(this.fNewLaunchConfigurationName);
        }
        this.fNewLaunchConfiguration.doSave();
        return new LaunchConfigurationBuildfileChange((ILaunchConfiguration)this.fNewLaunchConfiguration, this.fNewBuildfileLocation, this.fOldBuildfileLocation, oldProjectName, true);
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }

    private IFile getAssociatedFile(String location) {
        IFile file = null;
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            String expandedLocation = manager.performStringSubstitution(location);
            if (expandedLocation != null) {
                file = AntUtil.getFileForLocation(expandedLocation, null);
            }
        }
        catch (CoreException coreException) {}
        return file;
    }
}

