/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.RelationType;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class RelationAnnotationHelper {
    public static final String OutgoingRelationAnnotation = "http://www.polarsys.org/capella/vp/requirements/OutgoingRelation";
    public static final String IncomingRelationAnnotation = "http://www.polarsys.org/capella/vp/requirements/IncomingRelation";

    public static Collection<DAnnotation> getIncomingAnnotations(Requirement requirement) {
        LinkedHashSet<DAnnotation> result = new LinkedHashSet<DAnnotation>();
        for (EStructuralFeature.Setting s : SessionManager.INSTANCE.getSession((EObject)requirement).getSemanticCrossReferencer().getInverseReferences((EObject)requirement)) {
            DAnnotation annotation;
            if (!DescriptionPackage.Literals.DANNOTATION__REFERENCES.equals(s.getEStructuralFeature()) || !IncomingRelationAnnotation.equals((annotation = (DAnnotation)s.getEObject()).getSource())) continue;
            result.add(annotation);
        }
        return result;
    }

    public static Collection<DAnnotation> getOutgoingAnnotations(Requirement requirement) {
        LinkedHashSet<DAnnotation> result = new LinkedHashSet<DAnnotation>();
        for (EStructuralFeature.Setting s : SessionManager.INSTANCE.getSession((EObject)requirement).getSemanticCrossReferencer().getInverseReferences((EObject)requirement)) {
            DAnnotation annotation;
            if (!DescriptionPackage.Literals.DANNOTATION__REFERENCES.equals(s.getEStructuralFeature()) || !OutgoingRelationAnnotation.equals((annotation = (DAnnotation)s.getEObject()).getSource())) continue;
            result.add(annotation);
        }
        return result;
    }

    public static Collection<DAnnotation> getTypedAnnotations(RelationType type) {
        LinkedHashSet<DAnnotation> result = new LinkedHashSet<DAnnotation>();
        for (EStructuralFeature.Setting s : SessionManager.INSTANCE.getSession((EObject)type).getSemanticCrossReferencer().getInverseReferences((EObject)type)) {
            if (!DescriptionPackage.Literals.DANNOTATION__REFERENCES.equals(s.getEStructuralFeature())) continue;
            DAnnotation annotation = (DAnnotation)s.getEObject();
            result.add(annotation);
        }
        return result;
    }

    public static Collection<DAnnotation> getAllocations(DRepresentationDescriptor descriptor, String relationType) {
        return RelationAnnotationHelper.getAnnotations(relationType, descriptor);
    }

    public static DRepresentationDescriptor getDescriptor(DAnnotation annotation) {
        return (DRepresentationDescriptor)annotation.eContainer();
    }

    public static Requirement getRequirement(DAnnotation annotation) {
        return annotation.getReferences().stream().filter(r -> r instanceof Requirement).findFirst().orElse(null);
    }

    public static RelationType getRelationType(DAnnotation annotation) {
        return annotation.getReferences().stream().filter(r -> r instanceof RelationType).findFirst().orElse(null);
    }

    public static Collection<DAnnotation> getAnnotations(String source, DRepresentationDescriptor descriptor) {
        ArrayList<DAnnotation> result = new ArrayList<DAnnotation>();
        for (DAnnotation annotation : descriptor.getEAnnotations()) {
            if (annotation.getSource() == null || !annotation.getSource().equals(source)) continue;
            result.add(annotation);
        }
        return result;
    }

    public static void addAllocations(final DRepresentationDescriptor descriptor, final String relationType, final Collection<Couple<Requirement, RelationType>> elements) {
        TransactionHelper.getExecutionManager((EObject)descriptor).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                for (Couple entry : elements) {
                    DAnnotation annotation = DAnnotationHelper.createAnnotation((String)relationType, (DModelElement)descriptor);
                    EObject requirement = (EObject)entry.getKey();
                    EObject type = (EObject)entry.getValue();
                    annotation.getReferences().add((Object)requirement);
                    if (type == null) continue;
                    annotation.getReferences().add((Object)type);
                }
            }
        });
    }

    public static void removeAllocations(DRepresentationDescriptor descriptor, Collection<Object> elements) {
        RelationAnnotationHelper.removeAllocations(descriptor, IncomingRelationAnnotation, elements);
        RelationAnnotationHelper.removeAllocations(descriptor, OutgoingRelationAnnotation, elements);
    }

    public static void removeAllocations(final DRepresentationDescriptor descriptor, final String relationType, final Collection<Object> elements) {
        TransactionHelper.getExecutionManager((EObject)descriptor).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Collection<DAnnotation> annotations = RelationAnnotationHelper.getAnnotations(relationType, descriptor);
                for (Object requirement : elements) {
                    Collection toRemove = annotations.stream().filter(a -> requirement.equals(RelationAnnotationHelper.getRequirement(a))).collect(Collectors.toList());
                    for (DAnnotation annotation : toRemove) {
                        SiriusUtil.delete((EObject)annotation);
                    }
                }
            }
        });
    }

    public static void addAllocation(DRepresentationDescriptor descriptor, String relationType, Couple<Requirement, RelationType> element) {
        ArrayList<Couple<Requirement, RelationType>> res = new ArrayList<Couple<Requirement, RelationType>>();
        res.add(element);
        RelationAnnotationHelper.addAllocations(descriptor, relationType, res);
    }

    public static void removeAllocation(DRepresentationDescriptor descriptor, String relationType, final DAnnotation annotation) {
        if (annotation != null) {
            TransactionHelper.getExecutionManager((EObject)descriptor).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    SiriusUtil.delete((EObject)annotation);
                }
            });
        }
    }

    public static void updateAllocation(DRepresentationDescriptor descriptor, AbstractRelation relation, DAnnotation annotation) {
        String relationType = null;
        Requirement requirement = null;
        if (relation instanceof CapellaIncomingRelation) {
            relationType = IncomingRelationAnnotation;
            requirement = ((CapellaIncomingRelation)relation).getSource();
        } else if (relation instanceof CapellaOutgoingRelation) {
            relationType = OutgoingRelationAnnotation;
            requirement = ((CapellaOutgoingRelation)relation).getTarget();
        }
        if (requirement != null) {
            RelationAnnotationHelper.removeAllocation(descriptor, relationType, annotation);
            RelationAnnotationHelper.addAllocation(descriptor, relationType, (Couple<Requirement, RelationType>)new Couple((Object)requirement, (Object)relation.getRelationType()));
        }
    }
}

