/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.console;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.console.GradleConsole;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;

public final class CancelBuildExecutionAction
extends Action {
    private final GradleConsole gradleConsole;

    public CancelBuildExecutionAction(GradleConsole gradleConsole) {
        this.gradleConsole = (GradleConsole)((Object)Preconditions.checkNotNull((Object)((Object)gradleConsole)));
        this.setToolTipText(UiMessages.Action_CancelExecution_Tooltip);
        this.setImageDescriptor(PluginImages.CANCEL_BUILD_EXECUTION.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.CANCEL_BUILD_EXECUTION.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Optional<ProcessDescription> processDescription = this.gradleConsole.getProcessDescription();
        if (processDescription.isPresent()) {
            Job job = ((ProcessDescription)processDescription.get()).getJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    CancelBuildExecutionAction.this.setEnabled(event.getJob().getState() != 0);
                }
            });
            this.setEnabled(job.getState() != 0);
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        ((ProcessDescription)this.gradleConsole.getProcessDescription().get()).getJob().cancel();
    }

    public void dispose() {
    }
}

