/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.gradle.tooling.CancellationToken;

public final class RefreshJavaWorkspaceProjectJob
extends ToolingApiWorkspaceJob {
    private final IJavaProject project;

    public RefreshJavaWorkspaceProjectJob(IJavaProject project) {
        super("Initialize Gradle classpath for project '" + project.getElementName() + "'", false);
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Initializing classpath", 100);
        IJobManager manager = Job.getJobManager();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
        try {
            this.synchronizeWorkspaceProject(this.project, monitor, this.getToken());
        }
        finally {
            manager.endRule((ISchedulingRule)workspaceRoot);
        }
    }

    private void synchronizeWorkspaceProject(IJavaProject javaProject, IProgressMonitor monitor, CancellationToken token) throws CoreException {
        IProject project = javaProject.getProject();
        if (GradleProjectNature.INSTANCE.isPresentOn(project)) {
            Optional<OmniEclipseProject> gradleProject = this.findEclipseGradleProject(project, monitor, token);
            monitor.worked(50);
            if (gradleProject.isPresent()) {
                CorePlugin.workspaceGradleOperations().updateProjectInWorkspace(project, (OmniEclipseProject)gradleProject.get(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            } else {
                CorePlugin.workspaceGradleOperations().makeProjectGradleUnaware(project, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                ClasspathContainerUpdater.clear(javaProject, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            }
        } else {
            ClasspathContainerUpdater.clear(javaProject, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
    }

    private Optional<OmniEclipseProject> findEclipseGradleProject(IProject project, IProgressMonitor monitor, CancellationToken token) {
        ProjectConfiguration configuration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
        OmniEclipseGradleBuild eclipseGradleBuild = this.fetchEclipseGradleBuild(configuration.getRequestAttributes(), monitor, token);
        return eclipseGradleBuild.getRootEclipseProject().tryFind(Specs.eclipseProjectMatchesProjectPath(configuration.getProjectPath()));
    }

    private OmniEclipseGradleBuild fetchEclipseGradleBuild(FixedRequestAttributes fixedRequestAttributes, IProgressMonitor monitor, CancellationToken token) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList progressListeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), null, (List)progressListeners, (List)ImmutableList.of(), token);
        ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(fixedRequestAttributes);
        return repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
    }
}

