/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.workspace.internal.StringSetProjectProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

final class BuildCommandUpdater {
    private static final String PROJECT_PROPERTY_KEY_GRADLE_BUILD_COMMANDS = "build.commands";
    private final IProject project;
    private final ImmutableList<OmniEclipseBuildCommand> buildCommands;

    public BuildCommandUpdater(IProject project, List<OmniEclipseBuildCommand> buildCommands) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.buildCommands = ImmutableList.copyOf(buildCommands);
    }

    private void updateBuildCommands(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        StringSetProjectProperty knownCommands = StringSetProjectProperty.from(this.project, PROJECT_PROPERTY_KEY_GRADLE_BUILD_COMMANDS);
        this.removeBuildCommandsRemovedFromGradleModel(knownCommands, progress.newChild(1));
        this.addBuildCommandsNewInGradleModel(knownCommands, progress.newChild(1));
    }

    private void addBuildCommandsNewInGradleModel(StringSetProjectProperty knownCommands, SubMonitor progress) {
        progress.setWorkRemaining(this.buildCommands.size());
        LinkedHashSet newCommandNames = Sets.newLinkedHashSet();
        for (OmniEclipseBuildCommand buildCommand : this.buildCommands) {
            String name = buildCommand.getName();
            Map arguments = buildCommand.getArguments();
            CorePlugin.workspaceOperations().addBuildCommand(this.project, name, arguments, (IProgressMonitor)progress.newChild(1));
            newCommandNames.add(name);
        }
        knownCommands.set(newCommandNames);
    }

    private void removeBuildCommandsRemovedFromGradleModel(StringSetProjectProperty knownCommands, SubMonitor progress) {
        Set<String> buildCommands = knownCommands.get();
        progress.setWorkRemaining(buildCommands.size());
        for (String buildCommand : buildCommands) {
            SubMonitor childProgress = progress.newChild(1);
            if (this.buildCommandExistsInGradleModel(buildCommand)) continue;
            CorePlugin.workspaceOperations().removeBuildCommand(this.project, buildCommand, (IProgressMonitor)childProgress);
        }
    }

    private boolean buildCommandExistsInGradleModel(final String buildCommandName) {
        return FluentIterable.from(this.buildCommands).firstMatch((Predicate)new Predicate<OmniEclipseBuildCommand>(){

            public boolean apply(OmniEclipseBuildCommand command) {
                return command.getName().equals(buildCommandName);
            }
        }).isPresent();
    }

    public static void update(IProject project, Optional<List<OmniEclipseBuildCommand>> buildCommands, IProgressMonitor monitor) throws CoreException {
        List builderCommands = (List)buildCommands.or(Collections.emptyList());
        BuildCommandUpdater updater = new BuildCommandUpdater(project, builderCommands);
        updater.updateBuildCommands(monitor);
    }
}

