/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.gradle;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.util.List;
import org.gradle.util.GradleVersion;

public final class Limitations {
    private final GradleVersion targetVersion;

    public Limitations(GradleVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public List<Pair<GradleVersion, String>> getLimitations() {
        ImmutableList.Builder limitations = ImmutableList.builder();
        this.addIfNeeded("2.1", "No cancellation support", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.4", "No test progress visualization", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.5", "No build/task progress visualization", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.5", "No improved project classpath generation with all transitive dependencies as direct dependencies", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.6", "No running of tests from the Executions View", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.6", "No rerunning of failed tests from the Executions View", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.7", "No running of test classes and methods from the Editor", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.9", "No custom project natures and build commands applied", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.10", "Language source level not set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.11", "Target bytecode version not set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.11", "Java runtime not set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.13", "Improved performance when loading models", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.14", "Attributes defined for Java classpath entries", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("2.14", "WTP deployment attributes defined for web projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("3.0", "Output location, classpath containers, source folder excludes-includes and JRE name are set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        this.addIfNeeded("3.0", "Java classpath customization done in 'eclipse.classpath.file.whenMerged' is synchronized", (ImmutableList.Builder<Pair<GradleVersion, String>>)limitations);
        return limitations.build();
    }

    private void addIfNeeded(String version, String limitation, ImmutableList.Builder<Pair<GradleVersion, String>> limitations) {
        GradleVersion gradleVersion = GradleVersion.version((String)version);
        if (this.targetVersion.getBaseVersion().compareTo(gradleVersion) < 0) {
            limitations.add(this.createLimitation(gradleVersion, limitation));
        }
    }

    private Pair<GradleVersion, String> createLimitation(GradleVersion version, String limitation) {
        return new Pair((Object)version, (Object)(limitation + " in Gradle versions <" + version.getVersion() + "."));
    }
}

