/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.text.MessageFormat;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.IDECPListElement;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class IDECPListLabelProvider
extends LabelProvider {
    private String fNewLabel = Messages.getString((String)"IDECPListLabelProvider.new");
    private String fClassLabel = Messages.getString((String)"IDECPListLabelProvider.folder");
    private String fMissing = Messages.getString((String)"IDECPListLabelProvider.missing");
    private static final String[] fgArchiveExtensions = new String[]{"jar", "zip"};

    public String getText(Object element) {
        if (element instanceof IDECPListElement) {
            return this.getCPListElementText((IDECPListElement)element);
        }
        return super.getText(element);
    }

    public String getCPListElementText(IDECPListElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                IResource resource = cpentry.getResource();
                if (resource instanceof IContainer) {
                    StringBuilder buf = new StringBuilder(IDECPListLabelProvider.getPathLabel(path, false));
                    buf.append(' ');
                    buf.append(this.fClassLabel);
                    if (!resource.exists()) {
                        buf.append(' ');
                        if (cpentry.isMissing()) {
                            buf.append(this.fMissing);
                        } else {
                            buf.append(this.fNewLabel);
                        }
                    }
                    return buf.toString();
                }
                String label = this.getPathString(path, resource == null);
                if (cpentry.isMissing()) {
                    label = String.valueOf(label) + ' ' + this.fMissing;
                }
                return label;
            }
            case 4: {
                String label = this.getVariableString(path);
                if (cpentry.isMissing()) {
                    label = String.valueOf(label) + ' ' + this.fMissing;
                }
                return label;
            }
            case 2: {
                String label = path.lastSegment();
                if (cpentry.isMissing()) {
                    label = String.valueOf(label) + ' ' + this.fMissing;
                }
                return label;
            }
            case 3: {
                String pathLabel = IDECPListLabelProvider.getPathLabel(path, false);
                StringBuilder buf = new StringBuilder(pathLabel);
                IResource resource = cpentry.getResource();
                if (resource != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.isMissing()) {
                        buf.append(this.fMissing);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                } else if (cpentry.getOrginalPath() == null) {
                    buf.append(' ');
                    buf.append(this.fNewLabel);
                }
                return buf.toString();
            }
        }
        return Messages.getString((String)"IDECPListLabelProvider.unknown");
    }

    private String getPathString(IPath path, boolean isExternal) {
        if (IDECPListLabelProvider.isArchivePath(path, true)) {
            String appended = IDECPListLabelProvider.getPathLabel(path.removeLastSegments(1), isExternal);
            String lastSegment = path.lastSegment();
            return MessageFormat.format("{0} - {1}", lastSegment, appended);
        }
        return IDECPListLabelProvider.getPathLabel(path, isExternal);
    }

    public static boolean isArchivePath(IPath path, boolean allowAllAchives) {
        if (allowAllAchives) {
            return true;
        }
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            return IDECPListLabelProvider.isArchiveFileExtension(ext);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String ext) {
        int i = 0;
        while (i < fgArchiveExtensions.length) {
            if (ext.equalsIgnoreCase(fgArchiveExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getVariableString(IPath path) {
        String name = IDECPListLabelProvider.getPathLabel(path, false);
        IPath entryPath = JavaCore.getClasspathVariable((String)path.segment(0));
        if (entryPath != null) {
            String appended = IDECPListLabelProvider.getPathLabel(entryPath.append(path.removeFirstSegments(1)), true);
            return MessageFormat.format("{0} - {1}", name, appended);
        }
        return name;
    }

    private Image getCPListElementBaseImage(IDECPListElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 1: {
                IResource res = cpentry.getResource();
                if (res == null) {
                    if (IDECPListLabelProvider.isArchivePath(cpentry.getPath(), false)) {
                        return ReportPlatformUIImages.getImage((String)"ExtJar");
                    }
                    return ReportPlatformUIImages.getImage((String)"ExtFol");
                }
                if (res instanceof IFile) {
                    return ReportPlatformUIImages.getImage((String)"JAR");
                }
                return ReportPlatformUIImages.getImage((String)"FOL");
            }
            case 2: {
                return ReportPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            case 4: {
                return ReportPlatformUIImages.getImage((String)"VariableNodel");
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IDECPListElement) {
            IDECPListElement cpentry = (IDECPListElement)element;
            Image image = this.getCPListElementBaseImage(cpentry);
            return image;
        }
        return null;
    }

    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return label;
    }
}

