/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.ISqlDataValidator;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.core.services.SQLDataService;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionInitializer;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistry;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistryImpl;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;

public class SQLToolsFacade {
    private static SQLToolsFacade _instance = new SQLToolsFacade();

    private SQLToolsFacade() {
    }

    public static SQLToolsFacade getInstance() {
        return _instance;
    }

    private static SQLDevToolsConfigRegistry getRegistry() {
        return EditorCorePlugin.getDatabaseFactoryRegistry();
    }

    public static Collection getConfigurations() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        return c;
    }

    public static Collection getSupportedDBDefinitionNames() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        ArrayList<String> names = new ArrayList<String>();
        for (SQLDevToolsConfiguration factory : c) {
            String vendor = factory.getDatabaseVendorDefinitionId().getProductName();
            String version = factory.getDatabaseVendorDefinitionId().getVersion();
            names.add(String.valueOf(vendor) + "_" + version);
        }
        return names;
    }

    public static Collection getConnectibleDBDefinitionNames() {
        Iterator iter = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleProducts();
        ArrayList<String> names = new ArrayList<String>();
        while (iter.hasNext()) {
            String vendor = (String)iter.next();
            Iterator versions = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleVersions(vendor);
            while (versions.hasNext()) {
                String version = (String)versions.next();
                names.add(String.valueOf(vendor) + "_" + version);
            }
        }
        return names;
    }

    public static Collection getAllAvailableDBDefinitionIds() {
        HashSet<DatabaseVendorDefinitionId> ids = new HashSet<DatabaseVendorDefinitionId>();
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        for (SQLDevToolsConfiguration factory : c) {
            ids.add(factory.getDatabaseVendorDefinitionId());
        }
        Iterator iter = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleProducts();
        while (iter.hasNext()) {
            String vendor = (String)iter.next();
            Iterator versions = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleVersions(vendor);
            while (versions.hasNext()) {
                String version = (String)versions.next();
                ids.add(new DatabaseVendorDefinitionId(vendor, version));
            }
        }
        return ids;
    }

    public static Collection getAllAvailableDBDefinitionNames() {
        Collection Ids = SQLToolsFacade.getAllAvailableDBDefinitionIds();
        TreeSet<String> names = new TreeSet<String>();
        for (DatabaseVendorDefinitionId id : Ids) {
            names.add(id.toString());
        }
        return names;
    }

    public static SQLDevToolsConfiguration getConfigurationByDBDefName(String dbDefName) {
        return SQLToolsFacade.getConfigurationByVendorIdentifier(new DatabaseVendorDefinitionId(dbDefName));
    }

    public static SQLDevToolsConfiguration getConfigurationByVendorIdentifier(DatabaseVendorDefinitionId vendorId) {
        return SQLToolsFacade.getConfiguration(null, vendorId);
    }

    public static SQLDevToolsConfiguration getConfigurationByProfileName(String profileName) {
        return SQLToolsFacade.getConfigurationByVendorIdentifier(ProfileUtil.getDatabaseVendorDefinitionId(profileName));
    }

    public static SQLDevToolsConfiguration getConfiguration(DatabaseIdentifier databaseIdentifier, DatabaseVendorDefinitionId vendorId) {
        SQLDevToolsConfiguration f = null;
        if (databaseIdentifier != null) {
            f = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        }
        if (f == null && vendorId != null) {
            vendorId = SQLToolsFacade.getCanonicalDatabaseVendorDefinitionId(vendorId);
            f = SQLToolsFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        }
        if (f == null) {
            f = SQLToolsFacade.getDefaultConfiguration();
        }
        return f;
    }

    public static DatabaseVendorDefinitionId getCanonicalDatabaseVendorDefinitionId(DatabaseVendorDefinitionId vendorId) {
        DatabaseVendorDefinitionId oldVendorId = vendorId;
        DatabaseVendorDefinitionId defaultId = SQLToolsFacade.getDefaultConfiguration().getDatabaseVendorDefinitionId();
        SQLDevToolsConfiguration f = SQLToolsFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        if (f != null) {
            return f.getDatabaseVendorDefinitionId();
        }
        Collection configs = SQLToolsFacade.getConfigurations();
        ArrayList<DatabaseVendorDefinitionId> ids = new ArrayList<DatabaseVendorDefinitionId>();
        for (SQLDevToolsConfiguration conf : configs) {
            if (!conf.recognize(oldVendorId.getProductName(), oldVendorId.getVersion()) || conf.getDatabaseVendorDefinitionId().equals(defaultId)) continue;
            ids.add(conf.getDatabaseVendorDefinitionId());
        }
        if (ids.size() == 1) {
            return (DatabaseVendorDefinitionId)ids.get(0);
        }
        if (ids.size() > 1) {
            for (DatabaseVendorDefinitionId id : ids) {
                if (!id.equals(oldVendorId)) continue;
                return id;
            }
            return (DatabaseVendorDefinitionId)ids.get(0);
        }
        for (SQLDevToolsConfiguration conf : configs) {
            if (!conf.recognize(oldVendorId.getProductName(), "x") || conf.getDatabaseVendorDefinitionId().equals(defaultId)) continue;
            ids.add(conf.getDatabaseVendorDefinitionId());
        }
        DatabaseVendorDefinitionId.VersionComparator comparator = new DatabaseVendorDefinitionId.VersionComparator();
        if (ids.size() > 0) {
            String version = "0";
            for (DatabaseVendorDefinitionId v : ids) {
                if (comparator.compare(v.getVersion(), version) < 0) continue;
                version = v.getVersion();
            }
            return new DatabaseVendorDefinitionId(vendorId.getProductName(), version);
        }
        return defaultId;
    }

    public static DatabaseVendorDefinitionId getDeclaredDatabaseVendorDefinitionId(DatabaseVendorDefinitionId vendorId) {
        Collection allIds = SQLToolsFacade.getAllAvailableDBDefinitionIds();
        for (DatabaseVendorDefinitionId id : allIds) {
            if (!id.equals(vendorId)) continue;
            return id;
        }
        DatabaseVendorDefinitionId defaultId = SQLToolsFacade.getDefaultConfiguration().getDatabaseVendorDefinitionId();
        Collection configs = SQLToolsFacade.getConfigurations();
        ArrayList<DatabaseVendorDefinitionId> ids = new ArrayList<DatabaseVendorDefinitionId>();
        for (SQLDevToolsConfiguration conf : configs) {
            if (!conf.recognize(vendorId.getProductName(), "x") || conf.getDatabaseVendorDefinitionId().equals(defaultId)) continue;
            ids.add(conf.getDatabaseVendorDefinitionId());
        }
        if (ids.size() > 0) {
            DatabaseVendorDefinitionId.VersionComparator comparator = new DatabaseVendorDefinitionId.VersionComparator();
            for (DatabaseVendorDefinitionId id : ids) {
                if (comparator.compare(id.getVersion(), vendorId.getVersion()) != 0) continue;
                return id;
            }
            Iterator it = ids.iterator();
            if (it.hasNext()) {
                DatabaseVendorDefinitionId id;
                id = (DatabaseVendorDefinitionId)it.next();
                id = new DatabaseVendorDefinitionId(id.getProductName(), vendorId.getVersion());
                for (DatabaseVendorDefinitionId idDef : allIds) {
                    if (!idDef.equals(id)) continue;
                    return idDef;
                }
            }
            return (DatabaseVendorDefinitionId)ids.get(0);
        }
        return vendorId;
    }

    public static SQLDevToolsConfiguration getDefaultConfiguration() {
        SQLDevToolsConfiguration defaultConfiguration = SQLDevToolsConfigRegistryImpl.getDefaultConfiguration();
        if (defaultConfiguration == null) {
            defaultConfiguration = SQLDevToolsConfiguration.getDefaultInstance();
        }
        return defaultConfiguration;
    }

    public static DatabaseVendorDefinitionId getDefaultDatabaseVendorDefinitionId() {
        return SQLToolsFacade.getDefaultConfiguration().getDatabaseVendorDefinitionId();
    }

    public static DatabaseVendorDefinitionId getNonSpecificDatabaseVendorDefinitionId() {
        return SQLDevToolsConfiguration.getDefaultInstance().getDatabaseVendorDefinitionId();
    }

    public static DatabaseVendorDefinitionId recognize(String product, String version) {
        DatabaseVendorDefinitionId defaultId = SQLToolsFacade.getDefaultConfiguration().getDatabaseVendorDefinitionId();
        Collection configs = SQLToolsFacade.getConfigurations();
        for (SQLDevToolsConfiguration conf : configs) {
            if (!conf.recognize(product, version) || conf.getDatabaseVendorDefinitionId().equals(defaultId)) continue;
            return conf.getDatabaseVendorDefinitionId();
        }
        return defaultId;
    }

    public static int getConnectionId(DatabaseIdentifier databaseIdentifier, Connection conn) {
        if (databaseIdentifier == null || conn == null) {
            return 0;
        }
        try {
            if (conn.isClosed()) {
                return 0;
            }
        }
        catch (SQLException e) {
            EditorCorePlugin.getDefault().log(e);
        }
        ConnectionService service = SQLToolsFacade.getConnectionService(databaseIdentifier);
        return service.getConnectionId(databaseIdentifier, conn);
    }

    public static ConnectionService getConnectionService(DatabaseIdentifier databaseIdentifier) {
        ConnectionService service = SQLToolsFacade.getConfiguration(null, databaseIdentifier).getConnectionService();
        return service;
    }

    public static Runnable getConnectionKiller(DatabaseIdentifier databaseIdentifier, Connection conn) {
        ConnectionService service = SQLToolsFacade.getConnectionService(databaseIdentifier);
        if (service != null) {
            return service.getConnectionKiller(databaseIdentifier, conn);
        }
        return null;
    }

    public static IDatabaseSetting getDatabaseSetting(DatabaseIdentifier databaseIdentifier) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(null, databaseIdentifier);
        return f.getDatabaseSetting(databaseIdentifier);
    }

    public static IConnectionInitializer getConnectionInitializer(DatabaseIdentifier databaseIdentifier) {
        ConnectionService service = SQLToolsFacade.getConnectionService(databaseIdentifier);
        if (service != null) {
            return service.getConnectionInitializer();
        }
        return null;
    }

    public static DBHelper getDBHelper(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getDBHelper();
    }

    public static DBHelper getDBHelper(DatabaseIdentifier databaseIdentifier) {
        return SQLToolsFacade.getDBHelper(databaseIdentifier, null);
    }

    public static DBHelper getDBHelper(String dbType) {
        return SQLToolsFacade.getDBHelper(null, dbType);
    }

    public static SQLDataService getSQLDataService(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getSQLDataService();
    }

    public static ISqlDataValidator getSQLDataValidator(DatabaseIdentifier databaseIdentifier) {
        SQLDataService s = SQLToolsFacade.getSQLDataService(databaseIdentifier, null);
        if (s != null) {
            return s.getSQLDataValidator(databaseIdentifier);
        }
        return null;
    }

    public static SQLService getSQLService(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getSQLService();
    }

    public static ISQLSyntax getSQLSyntax(String dbType) {
        SQLService s = SQLToolsFacade.getSQLService(null, dbType);
        if (s != null) {
            return s.getSQLSyntax();
        }
        return null;
    }

    public static int[] getDBTypes() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        int size = c.size();
        String[] types = c.toArray(new String[size]);
        int[] ts = new int[size];
        int i = 0;
        while (i < size) {
            ts[i] = Integer.parseInt(types[i]);
            ++i;
        }
        return ts;
    }

    public static SQLDevToolsConfiguration getConfiguration(String dbType, DatabaseIdentifier databaseIdentifier) {
        if (dbType == null) {
            return SQLToolsFacade.getConfiguration(databaseIdentifier, null);
        }
        return SQLToolsFacade.getConfiguration(databaseIdentifier, new DatabaseVendorDefinitionId(dbType));
    }

    public static SQLParser getSQLParser(String profileName, String dbType) {
        SQLService s = SQLToolsFacade.getSQLService(new DatabaseIdentifier(profileName), dbType);
        if (s != null) {
            return s.getSQLParser();
        }
        return null;
    }
}

