/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.CompositeSerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.DynamicCompositeSerializer;
import me.prettyprint.cassandra.serializers.FloatSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.template.AbstractTemplateUpdater;
import me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import me.prettyprint.hector.api.ColumnFactory;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import me.prettyprint.hector.api.beans.DynamicComposite;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.mutation.Mutator;

public class ColumnFamilyUpdater<K, N>
extends AbstractTemplateUpdater<K, N> {
    public ColumnFamilyUpdater(ColumnFamilyTemplate<K, N> template, ColumnFactory columnFactory) {
        super(template, columnFactory, template.createMutator());
    }

    public ColumnFamilyUpdater(ColumnFamilyTemplate<K, N> template, ColumnFactory columnFactory, Mutator<K> mutator) {
        super(template, columnFactory, mutator);
    }

    public void deleteColumn(N columnName) {
        this.mutator.addDeletion(this.getCurrentKey(), this.template.getColumnFamily(), columnName, this.template.getTopSerializer());
    }

    public void setString(N columnName, String value) {
        this.addInsertion(columnName, value, StringSerializer.get(), this.globalTtl);
    }

    public void setString(N columnName, String value, int ttl) {
        this.addInsertion(columnName, value, StringSerializer.get(), ttl);
    }

    public void setUUID(N columnName, UUID value) {
        this.addInsertion(columnName, value, UUIDSerializer.get(), this.globalTtl);
    }

    public void setUUID(N columnName, UUID value, int ttl) {
        this.addInsertion(columnName, value, UUIDSerializer.get(), ttl);
    }

    public void setLong(N columnName, Long value) {
        this.addInsertion(columnName, value, LongSerializer.get(), this.globalTtl);
    }

    public void setLong(N columnName, Long value, int ttl) {
        this.addInsertion(columnName, value, LongSerializer.get(), ttl);
    }

    public void setInteger(N columnName, Integer value) {
        this.addInsertion(columnName, value, IntegerSerializer.get(), this.globalTtl);
    }

    public void setInteger(N columnName, Integer value, int ttl) {
        this.addInsertion(columnName, value, IntegerSerializer.get(), ttl);
    }

    public void setFloat(N columnName, Float value) {
        this.addInsertion(columnName, value, FloatSerializer.get(), this.globalTtl);
    }

    public void setFloat(N columnName, Float value, int ttl) {
        this.addInsertion(columnName, value, FloatSerializer.get(), ttl);
    }

    public void setDouble(N columnName, Double value) {
        this.addInsertion(columnName, value, DoubleSerializer.get(), this.globalTtl);
    }

    public void setDouble(N columnName, Double value, int ttl) {
        this.addInsertion(columnName, value, DoubleSerializer.get(), ttl);
    }

    public void setBoolean(N columnName, Boolean value) {
        this.addInsertion(columnName, value, BooleanSerializer.get(), this.globalTtl);
    }

    public void setBoolean(N columnName, Boolean value, int ttl) {
        this.addInsertion(columnName, value, BooleanSerializer.get(), ttl);
    }

    public void setByteArray(N columnName, byte[] value) {
        this.addInsertion(columnName, value, BytesArraySerializer.get(), this.globalTtl);
    }

    public void setByteArray(N columnName, byte[] value, int ttl) {
        this.addInsertion(columnName, value, BytesArraySerializer.get(), ttl);
    }

    public void setByteBuffer(N columnName, ByteBuffer value) {
        this.addInsertion(columnName, value, ByteBufferSerializer.get(), this.globalTtl);
    }

    public void setByteBuffer(N columnName, ByteBuffer value, int ttl) {
        this.addInsertion(columnName, value, ByteBufferSerializer.get(), this.globalTtl);
    }

    public void setDate(N columnName, Date value) {
        this.addInsertion(columnName, value, DateSerializer.get(), this.globalTtl);
    }

    public <V> void setFloat(N columnName, float value) {
        this.addInsertion(columnName, Float.valueOf(value), FloatSerializer.get(), this.globalTtl);
    }

    public <V> void setComposite(N columnName, Composite composite) {
        this.addInsertion(columnName, composite, CompositeSerializer.get(), this.globalTtl);
    }

    public <V> void setDynamicComposite(N columnName, DynamicComposite composite) {
        this.addInsertion(columnName, composite, DynamicCompositeSerializer.get(), this.globalTtl);
    }

    public <V> void setValue(N columnName, V value, Serializer<V> serializer) {
        this.addInsertion(columnName, value, serializer, this.globalTtl);
    }

    public <V> void setValue(N columnName, V value, Serializer<V> serializer, int ttl) {
        this.addInsertion(columnName, value, serializer, ttl);
    }

    private <V> void addInsertion(N columnName, V value, Serializer<V> valueSerializer, int ttl) {
        HColumn<N, V> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), valueSerializer);
        if (ttl > 0) {
            column.setTtl(ttl);
        }
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public <V> void setColumn(HColumn<N, V> column) {
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }
}

