/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.AbstractSerializer;

public class FloatTypeSerializer
extends AbstractSerializer<Float> {
    private static final FloatTypeSerializer instance = new FloatTypeSerializer();

    public static FloatTypeSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Float obj) {
        if (obj == null) {
            return null;
        }
        byte[] bytes = new byte[4];
        ByteBuffer result = ByteBuffer.wrap(bytes).putFloat(obj.floatValue());
        result.rewind();
        return result;
    }

    @Override
    public Float fromByteBuffer(ByteBuffer byteBuffer) {
        float result = byteBuffer.getFloat();
        return Float.valueOf(result);
    }
}

