/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.locking;

import java.util.Arrays;
import me.prettyprint.cassandra.service.AbstractCluster;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.locking.HLockManager;
import me.prettyprint.hector.api.locking.HLockManagerConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLockManager
implements HLockManager {
    protected static final String DUMMY_VALUE = "v";
    private static final Logger log = LoggerFactory.getLogger(AbstractLockManager.class);
    protected Cluster cluster;
    protected Keyspace keyspace;
    protected HLockManagerConfigurator lockManagerConfigurator;

    public AbstractLockManager(Cluster cluster, Keyspace keyspace, HLockManagerConfigurator lockManagerConfigurator) {
        if (cluster == null) {
            throw new RuntimeException("Cluster cannot be null for LockManager");
        }
        this.cluster = cluster;
        this.lockManagerConfigurator = lockManagerConfigurator;
        if (lockManagerConfigurator == null) {
            this.lockManagerConfigurator = new HLockManagerConfigurator();
        }
        if (keyspace == null) {
            this.keyspace = HFactory.createKeyspace(this.lockManagerConfigurator.getKeyspaceName(), cluster);
        } else {
            this.keyspace = keyspace;
            this.lockManagerConfigurator.setKeyspaceName(keyspace.getKeyspaceName());
        }
    }

    public AbstractLockManager(Cluster cluster) {
        this(cluster, null, null);
    }

    public AbstractLockManager(Cluster cluster, HLockManagerConfigurator hlmc) {
        this(cluster, null, hlmc);
    }

    public AbstractLockManager(Cluster cluster, Keyspace keyspace) {
        this(cluster, keyspace, null);
    }

    @Override
    public void init() {
        log.info(this.lockManagerConfigurator.toString());
        this.checkCreateLockSchema();
    }

    private void checkCreateLockSchema() {
        KeyspaceDefinition keyspaceDef = this.cluster.describeKeyspace(this.keyspace.getKeyspaceName());
        if (keyspaceDef == null) {
            ColumnFamilyDefinition cfDef = this.createColumnFamilyDefinition();
            KeyspaceDefinition newKeyspace = HFactory.createKeyspaceDefinition(this.keyspace.getKeyspaceName(), "org.apache.cassandra.locator.SimpleStrategy", this.lockManagerConfigurator.getReplicationFactor(), Arrays.asList(cfDef));
            log.info("Creating Keyspace and Column Family for LockManager with name (KSPS/CF): (" + newKeyspace.getName() + " / " + cfDef.getName());
            this.cluster.addKeyspace(newKeyspace, true);
        } else {
            log.info("Keyspace for LockManager already exists. Skipping creation.");
            if (!this.doesLockCFExist(keyspaceDef)) {
                ColumnFamilyDefinition cfDef = this.createColumnFamilyDefinition();
                log.info("Creating Column Family for LockManager with name: " + cfDef.getName());
                this.cluster.addColumnFamily(cfDef, true);
            } else {
                log.info("Column Family for LockManager already exists. Skipping creation.");
            }
        }
    }

    private ColumnFamilyDefinition createColumnFamilyDefinition() {
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition(this.keyspace.getKeyspaceName(), this.lockManagerConfigurator.getLockManagerCF(), ComparatorType.UTF8TYPE);
        cfDef.setKeyValidationClass(ComparatorType.UTF8TYPE.getClassName());
        cfDef.setRowCacheSize(this.lockManagerConfigurator.isRowsCacheEnabled() ? 10000.0 : 0.0);
        return cfDef;
    }

    private boolean doesLockCFExist(KeyspaceDefinition keyspaceDef) {
        for (ColumnFamilyDefinition cfdef : keyspaceDef.getCfDefs()) {
            if (!cfdef.getName().equals(this.lockManagerConfigurator.getLockManagerCF())) continue;
            return true;
        }
        return false;
    }

    private CassandraHostConfigurator getConfigurator() {
        return ((AbstractCluster)this.cluster).getConfigurator();
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public HLockManagerConfigurator getLockManagerConfigurator() {
        return this.lockManagerConfigurator;
    }

    public void setLockManagerConfigurator(HLockManagerConfigurator lockManagerConfigurator) {
        this.lockManagerConfigurator = lockManagerConfigurator;
    }
}

