/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.plugin;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.extension.ExtensibilityProvider;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.plugin.ODAManifestUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

public class OdaExtensibilityProvider
extends ExtensibilityProvider
implements ODAProvider {
    String extensionID = null;

    public OdaExtensibilityProvider(DesignElement element, String extensionID) {
        super(element);
        if (element == null) {
            throw new IllegalArgumentException("element can not be null!");
        }
        this.extensionID = extensionID;
        this.cachedExtDefn = extensionID == null ? null : (ExtensionElementDefn)MetaDataDictionary.getInstance().getElement(extensionID);
    }

    @Override
    public List<IElementPropertyDefn> getPropertyDefns() {
        if (this.getExtDefn() == null) {
            return Collections.emptyList();
        }
        List<IElementPropertyDefn> list = this.getExtDefn().getProperties();
        List<UserPropertyDefn> userProps = this.element.getUserProperties();
        if (userProps != null) {
            list.addAll(userProps);
        }
        return list;
    }

    @Override
    public ElementPropertyDefn getPropertyDefn(String propName) {
        if (this.getExtDefn() == null) {
            return null;
        }
        ElementPropertyDefn propDefn = (ElementPropertyDefn)this.getExtDefn().getProperty(propName);
        if (propDefn == null) {
            propDefn = this.element.getUserPropertyDefn(propName);
        }
        return propDefn;
    }

    @Override
    public void checkExtends(DesignElement parent) throws ExtendsException {
        String parentExt = (String)parent.getProperty(null, "extensionID");
        assert (this.extensionID != null);
        if (!this.extensionID.equalsIgnoreCase(parentExt)) {
            throw new WrongTypeException(this.element, parent, "Error.WrongTypeException.WRONG_EXTENSION_TYPE");
        }
    }

    @Override
    public ExtensionElementDefn getExtDefn() {
        return this.cachedExtDefn;
    }

    @Override
    public String convertExtensionID() {
        if (this.element instanceof OdaDataSource) {
            String id = this.extensionID;
            ExtensionManifest manifest = ODAManifestUtil.getDataSourceExtension(id);
            if (manifest != null && manifest.isDeprecated()) {
                id = manifest.getRelatedDataSourceId();
            }
            return id;
        }
        if (this.element instanceof OdaDataSet) {
            String id = this.extensionID;
            DataSetType type = ODAManifestUtil.getDataSetExtension(id);
            if (type != null && type.isDeprecated()) {
                id = type.getRelatedDataSetId();
            }
            return id;
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isValidExtensionID() {
        return this.element instanceof OdaDataSet && ODAManifestUtil.getDataSetExtension(this.extensionID) != null || this.element instanceof OdaDataSource && ODAManifestUtil.getDataSourceExtension(this.extensionID) != null;
    }
}

