/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TemplateDataSet;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.util.ModelUtil;

public class TemplateFactory {
    public static TemplateElement createTemplate(Module module, DesignElement defaultElement, String name) {
        assert (defaultElement != null);
        if (!ModelUtil.isTemplateSupported(defaultElement)) {
            return null;
        }
        if (defaultElement instanceof ReportItem) {
            if (StringUtil.isBlank(name)) {
                return new TemplateReportItem();
            }
            return new TemplateReportItem(name);
        }
        if (defaultElement instanceof SimpleDataSet) {
            TemplateDataSet template = new TemplateDataSet(name);
            assert (module != null);
            module.makeUniqueName(template);
            return template;
        }
        return null;
    }
}

