/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.List;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;

public class AggregationArgument
extends Structure {
    public static final String STRUCTURE_NAME = "AggregationArgument";
    public static final String NAME_MEMBER = "name";
    public static final String VALUE_MEMBER = "value";
    private String name = null;
    private Expression value = null;

    @Override
    public String getStructName() {
        return STRUCTURE_NAME;
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (NAME_MEMBER.equals(propName)) {
            return this.name;
        }
        if (VALUE_MEMBER.equals(propName)) {
            return this.value;
        }
        assert (false);
        return null;
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if (NAME_MEMBER.equals(propName)) {
            this.name = (String)value;
        } else if (VALUE_MEMBER.equals(propName)) {
            this.value = (Expression)value;
        } else assert (false);
    }

    public String getName() {
        return (String)this.getProperty(null, NAME_MEMBER);
    }

    public void setName(String argumentName) {
        this.setProperty(NAME_MEMBER, (Object)argumentName);
    }

    public String getValue() {
        return this.getStringProperty(null, VALUE_MEMBER);
    }

    public void setValue(String argumentValue) {
        this.setProperty(VALUE_MEMBER, (Object)argumentValue);
    }

    @Override
    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new AggregationArgumentHandle(valueHandle, index);
    }

    public List validate(Module module, DesignElement element) {
        List<SemanticException> list = super.validate(module, element);
        if (StringUtil.isBlank(this.name)) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), (Object)this.name, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }
}

