/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.activity.IFilterCondition;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.activity.IEventFilter;

public class EventFilter
implements IEventFilter {
    private List<IFilterCondition> conditions = new ArrayList<IFilterCondition>();

    public EventFilter(List<IFilterCondition> conds) {
        this.conditions = conds;
    }

    @Override
    public List<RecordTask> filter(List<RecordTask> events) {
        if (events == null || events.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.conditions == null || this.conditions.isEmpty()) {
            return events;
        }
        ArrayList<RecordTask> filteredEvents = new ArrayList<RecordTask>(events);
        int size = filteredEvents.size();
        if (size == 1) {
            return events;
        }
        for (IFilterCondition filter : this.conditions) {
            if (filter == null) continue;
            int i = 0;
            while (i < size) {
                NotificationRecordTask wrapper1 = (NotificationRecordTask)filteredEvents.get(i);
                int j = 0;
                while (j < size) {
                    int filteredEvent;
                    NotificationRecordTask wrapper2;
                    if (!(j == i || (wrapper2 = (NotificationRecordTask)filteredEvents.get(j)).isFiltered() && wrapper1.isFiltered() || (filteredEvent = filter.getFilterEvent(wrapper1.getEvent(), wrapper2.getEvent())) == 3)) {
                        this.doFilter(filteredEvent, wrapper1, wrapper2);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return new ArrayList<RecordTask>(filteredEvents);
    }

    private void doFilter(int filteredEvent, NotificationRecordTask wrapper1, NotificationRecordTask wrapper2) {
        assert (wrapper1 != null && wrapper2 != null);
        switch (filteredEvent) {
            case 0: {
                wrapper1.setFiltered(true);
                return;
            }
            case 1: {
                wrapper2.setFiltered(true);
                return;
            }
            case 2: {
                wrapper1.setFiltered(true);
                wrapper2.setFiltered(true);
            }
        }
    }
}

