/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.CDialogCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class BackgroundImageCellEditor
extends CDialogCellEditor {
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    Listener filter = new Listener(){

        public void handleEvent(Event event) {
            if (BackgroundImageCellEditor.this.text.isDisposed()) {
                return;
            }
            BackgroundImageCellEditor.this.handleFocus(16);
        }
    };
    boolean hasFocus = false;
    private static final int defaultStyle = 4;
    private Text text;

    public BackgroundImageCellEditor(Composite parent) {
        super(parent);
        this.setStyle(4);
    }

    public BackgroundImageCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        Composite composite = new Composite(cell, this.getStyle());
        composite.setBackground(bg);
        composite.setLayout((Layout)new FillLayout());
        this.text = new Text(composite, 0);
        this.text.setBackground(bg);
        this.text.setFont(cell.getFont());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    BackgroundImageCellEditor.this.fireCancelEditor();
                } else if (e.character == '\r') {
                    BackgroundImageCellEditor.this.doSetValue(BackgroundImageCellEditor.this.text.getText());
                    BackgroundImageCellEditor.this.fireApplyEditorValue();
                    BackgroundImageCellEditor.this.deactivate();
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BackgroundImageCellEditor.this.doSetValue(BackgroundImageCellEditor.this.text.getText());
                if (BackgroundImageCellEditor.this.text != null && !BackgroundImageCellEditor.this.text.isDisposed()) {
                    BackgroundImageCellEditor.this.focusLost();
                }
            }

            public void focusGained(FocusEvent e) {
                BackgroundImageCellEditor.this.handleFocus(15);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BackgroundImageCellEditor.this.markDirty();
            }
        });
        return composite;
    }

    void handleFocus(int type) {
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.text.selectAll();
                this.hasFocus = true;
                Display display = this.text.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.text.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.text.getDisplay().getFocusControl();
                if (focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Display display = this.text.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.text.notifyListeners(16, e);
            }
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        String file;
        String[] extensions = new String[]{"*.bmp;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.png;*.tif;*.tiff;*.ico;*.svg"};
        ResourceSelectionValidator validator = new ResourceSelectionValidator(IMAGE_TYPES);
        ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, true, extensions);
        dialog.setEmptyFolderShowStatus(2);
        dialog.setTitle(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Title"));
        dialog.setMessage(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Message"));
        dialog.setValidator(validator);
        if (dialog.open() == 0 && (file = dialog.getPath()) != null) {
            if (!this.checkExtensions(IMAGE_TYPES, file)) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Title"), Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Message"));
                return null;
            }
            return file;
        }
        return null;
    }

    private boolean checkExtensions(String[] fileExt, String fileName) {
        int i = 0;
        while (i < fileExt.length) {
            String ext = fileExt[i].substring(fileExt[i].lastIndexOf(46));
            if (fileName.toLowerCase().endsWith(ext.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void updateContents(Object value) {
        if (this.text == null) {
            return;
        }
        if (value != null) {
            this.text.setText(value.toString());
        }
    }

    protected void doSetFocus() {
        this.text.setFocus();
    }

    @Override
    protected void doValueChanged() {
    }
}

