/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDragAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public class DNDService
implements IRegistryChangeListener {
    public static final int LOGIC_TRUE = 1;
    public static final int LOGIC_FALSE = -1;
    public static final int LOGIC_UNKNOW = 0;
    private List dragAdapterList = new ArrayList();
    private List dropAdapterList = new ArrayList();
    protected Logger logger = Logger.getLogger(DNDService.class.getName());

    private DNDService() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.birt.report.designer.ui.DNDServices");
        if (extensionPoint != null) {
            this.addRegistry(extensionPoint);
        }
    }

    public static DNDService getInstance() {
        return DNDServiceInstance.instance;
    }

    public boolean validDrag(Object object) {
        if ((object = this.adaptObject(object)) instanceof Object[] && ((Object[])object).length == 1) {
            return this.validDrag(((Object[])object)[0]);
        }
        for (IDragAdapter dragAdapter : this.dragAdapterList) {
            int result = dragAdapter.canDrag(object);
            if (result == 1) {
                return true;
            }
            if (result != -1) continue;
            return false;
        }
        return false;
    }

    public Object getDragTransfer(Object object) {
        for (IDragAdapter dragAdapter : this.dragAdapterList) {
            int result = dragAdapter.canDrag(object);
            if (result != 1) continue;
            return dragAdapter.getDragTransfer(object);
        }
        return null;
    }

    public boolean validDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (transfer instanceof Object[] && ((Object[])transfer).length == 1) {
            return this.validDrop(((Object[])transfer)[0], target, operation, location);
        }
        transfer = this.adaptObject(transfer);
        for (IDropAdapter dropAdapter : this.dropAdapterList) {
            int result = dropAdapter.canDrop(transfer, target, operation, location);
            if (result == 1) {
                return true;
            }
            if (result != -1) continue;
            return false;
        }
        return false;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (transfer instanceof Object[] && ((Object[])transfer).length == 1) {
            return this.performDrop(((Object[])transfer)[0], target, operation, location);
        }
        transfer = this.adaptObject(transfer);
        for (IDropAdapter dropAdapter : this.dropAdapterList) {
            int result = dropAdapter.canDrop(transfer, target, operation, location);
            if (result != 1) continue;
            return dropAdapter.performDrop(transfer, target, operation, location);
        }
        return false;
    }

    private Object adaptObject(Object adapter) {
        if (adapter instanceof Object[] && ((Object[])adapter).length > 0) {
            Object[] adapters = (Object[])adapter;
            if (this.adaptObject(adapters[0]) != adapters[0]) {
                Object[] array = new Object[adapters.length];
                int i = 0;
                while (i < array.length) {
                    array[i] = this.adaptObject(adapters[i]);
                    ++i;
                }
                return array;
            }
        } else if (adapter instanceof IAdaptable) {
            Object object = ((IAdaptable)adapter).getAdapter(DesignElementHandle.class);
            if (object != null) {
                return object;
            }
            object = ((IAdaptable)adapter).getAdapter(PropertyHandle.class);
            if (object != null) {
                return object;
            }
        }
        return adapter;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.birt.report.designer.ui", "DNDServices");
        int i = 0;
        while (i < deltas.length) {
            if (deltas[i].getKind() == 1) {
                this.addRegistry(deltas[i].getExtensionPoint());
            } else if (deltas[i].getKind() == 2) {
                this.removeRegistry(deltas[i].getExtensionPoint());
            }
            ++i;
        }
    }

    private void addRegistry(IExtensionPoint extensionPoint) {
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            Object adapter;
            if (configElements[i].getName().equals("dragAdapter")) {
                try {
                    adapter = (IDragAdapter)configElements[i].createExecutableExtension("adapter");
                    this.dragAdapterList.add(adapter);
                    if (Policy.TRACING_DND) {
                        System.out.println("[add dragAdapter]" + configElements[i].getAttribute("adapter"));
                    }
                }
                catch (CoreException e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            } else if (configElements[i].getName().equals("dropAdapter")) {
                try {
                    adapter = (IDropAdapter)configElements[i].createExecutableExtension("adapter");
                    this.dropAdapterList.add(adapter);
                    if (Policy.TRACING_DND) {
                        System.out.println("[add dropAdapter]" + configElements[i].getAttribute("adapter"));
                    }
                }
                catch (CoreException e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            ++i;
        }
    }

    private void removeRegistry(IExtensionPoint extensionPoint) {
    }

    private static class DNDServiceInstance {
        static DNDService instance = new DNDService();

        private DNDServiceInstance() {
        }
    }
}

