/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.utils;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.utils.JDBCDriverInfoManager;
import org.eclipse.birt.report.data.oda.jdbc.utils.JDBCDriverInformation;
import org.eclipse.birt.report.data.oda.jdbc.utils.PropertyElement;
import org.eclipse.birt.report.data.oda.jdbc.utils.PropertyGroup;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;

public final class ResourceLocator {
    private static Logger logger = Logger.getLogger(ResourceLocator.class.getName());

    public static void resolveConnectionProperties(Properties connectionProperties, String driverClass, Map appContext) throws OdaException {
        JDBCDriverInformation info = JDBCDriverInfoManager.getInstance().getDriversInfo(driverClass);
        if (info != null) {
            List<PropertyGroup> group = info.getPropertyGroup();
            int i = 0;
            while (i < group.size()) {
                List<PropertyElement> elements = group.get(i).getProperties();
                int j = 0;
                while (j < elements.size()) {
                    String type;
                    String propertyName = elements.get(j).getAttribute("propertyName");
                    if (connectionProperties.containsKey(propertyName) && "resource".equals(type = elements.get(j).getAttribute("type"))) {
                        String path = ResourceLocator.resolveResource(connectionProperties.getProperty(propertyName), appContext);
                        connectionProperties.setProperty(propertyName, path);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static String resolveResource(String location, Map appContext) throws OdaException {
        String absolutePath = null;
        if (location != null) {
            if (appContext == null) {
                logger.warning("No ResourceIdentifiers instance is provided from appContext");
                absolutePath = location;
            } else if (new File(location).isAbsolute()) {
                absolutePath = location;
            } else {
                Object obj = appContext.get("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds");
                if (obj != null) {
                    try {
                        absolutePath = ResourceLocator.getResourcePath(obj, new URI(ResourceLocator.encode(location)));
                    }
                    catch (URISyntaxException e) {
                        logger.log(Level.WARNING, "Failed to resolve path", e);
                        absolutePath = location;
                    }
                } else {
                    logger.warning("No ResourceIdentifiers instance is provided from appContext");
                    absolutePath = location;
                }
            }
            if (absolutePath == null) {
                logger.logp(Level.SEVERE, location, "open", "cannot find file under location " + location);
                throw new OdaException("cannot find file " + location);
            }
            File docFile = new File(absolutePath);
            if (docFile == null || !docFile.exists()) {
                throw new OdaException("cannot find file under location " + absolutePath);
            }
        }
        return absolutePath;
    }

    private static String getResourcePath(Object resourceIdentifiersObj, URI path) throws OdaException {
        if (resourceIdentifiersObj == null) {
            return null;
        }
        if (resourceIdentifiersObj instanceof ResourceIdentifiers) {
            ResourceIdentifiers.URILocator appLocator = ((ResourceIdentifiers)resourceIdentifiersObj).getApplResourceURILocator();
            ResourceIdentifiers.URILocator designLocator = ((ResourceIdentifiers)resourceIdentifiersObj).getDesignResourceURILocator();
            if (appLocator == null && designLocator == null) {
                throw new OdaException("cannot find resource identifier");
            }
            URI target = null;
            if (appLocator != null) {
                target = appLocator.resolve(path);
            }
            if (target == null) {
                target = designLocator.resolve(path);
            }
            if (target == null) {
                return null;
            }
            return target.getPath();
        }
        Method resolveAppResourceMethod = ResourceLocator.findMethod(resourceIdentifiersObj, "resolveApplResource", new Class[]{URI.class});
        Method resolveDesignResourceMethod = ResourceLocator.findMethod(resourceIdentifiersObj, "resolveDesignResource", new Class[]{URI.class});
        Object result = null;
        if (resolveAppResourceMethod != null) {
            result = ResourceLocator.invokeMethod(resourceIdentifiersObj, resolveAppResourceMethod, new Object[]{path});
        }
        if (result == null || !(result instanceof URI)) {
            result = ResourceLocator.invokeMethod(resourceIdentifiersObj, resolveDesignResourceMethod, new Object[]{path});
        }
        if (result instanceof URI) {
            return ((URI)result).getPath();
        }
        return null;
    }

    private static Object invokeMethod(Object anObj, Method objMethod, Object[] arg) {
        Object returnValue = null;
        try {
            returnValue = objMethod.invoke(anObj, arg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
        return returnValue;
    }

    private static Method findMethod(Object anObj, String methodName, Class[] argument) {
        Class<?> clazz = anObj.getClass();
        Method theMethod = null;
        try {
            theMethod = clazz.getDeclaredMethod(methodName, argument);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return theMethod;
    }

    private static String encode(String location) {
        try {
            if (File.separatorChar != '/') {
                location = location.replace(File.separatorChar, '/');
            }
            if (location.startsWith("/")) {
                return new File(location).toURI().toASCIIString().replace(new File("/").toURI().toASCIIString(), "/");
            }
            return new File(location).toURI().toASCIIString().replace(new File("").toURI().toASCIIString(), "");
        }
        catch (Exception e) {
            return location;
        }
    }
}

