/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.events.internal;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectListenerRegistry {
    private final Map<IFacetedProjectEvent.Type, Set<IFacetedProjectListener>> listeners = new EnumMap<IFacetedProjectEvent.Type, Set<IFacetedProjectListener>>(IFacetedProjectEvent.Type.class);

    public ProjectListenerRegistry() {
        IFacetedProjectEvent.Type[] typeArray = IFacetedProjectEvent.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFacetedProjectEvent.Type t = typeArray[n2];
            this.listeners.put(t, new CopyOnWriteArraySet());
            ++n2;
        }
    }

    public void addListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        if (listener == null || types == null) {
            throw new IllegalArgumentException();
        }
        IFacetedProjectEvent.Type[] typeArray = types.length > 0 ? types : IFacetedProjectEvent.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFacetedProjectEvent.Type type = typeArray[n2];
            this.listeners.get((Object)type).add(listener);
            ++n2;
        }
    }

    public void removeListener(IFacetedProjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        for (Set<IFacetedProjectListener> listeners : this.listeners.values()) {
            listeners.remove(listener);
        }
    }

    public void notifyListeners(IFacetedProjectEvent event) {
        for (IFacetedProjectListener listener : this.listeners.get((Object)event.getType())) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
        }
    }

    public Set<IFacetedProjectListener> getListeners(IFacetedProjectEvent.Type eventType) {
        return this.listeners.get((Object)eventType);
    }
}

