/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.birt.report.engine.internal.executor.doc.FragmentComparator;

public class Segment {
    LinkedList<SegmentEdge> edges = new LinkedList();
    Object[][] sections;
    Comparator comparator;
    public static final Object LEFT_MOST_EDGE = "LEFT";
    public static final Object RIGHT_MOST_EDGE = "RIGHT";

    Segment(Comparator comparator) {
        if (!(comparator instanceof FragmentComparator)) {
            comparator = new FragmentComparator(comparator);
        }
        this.comparator = comparator;
    }

    void startSegment(Object left) {
        this.addEdge(left, true);
    }

    void endSegment(Object right) {
        this.addEdge(right, false);
    }

    boolean inSegment(Object offset) {
        if (this.sections == null) {
            this.normalize();
        }
        int i = 0;
        while (i < this.sections.length) {
            Object[] sect = this.sections[i];
            if (this.comparator.compare(sect[0], offset) <= 0 && this.comparator.compare(sect[1], offset) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addEdge(Object offset, boolean left) {
        this.sections = null;
        SegmentEdge edge = new SegmentEdge(offset, left);
        this.edges.add(edge);
    }

    @Deprecated
    void insertSection(Object left, Object right) {
        this.sections = null;
        SegmentEdge edge = null;
        if (left == LEFT_MOST_EDGE && right == RIGHT_MOST_EDGE) {
            while (this.edges.size() > 0) {
                this.edges.remove();
            }
            edge = new SegmentEdge(left, true);
            this.edges.add(edge);
            edge = new SegmentEdge(right, false);
            this.edges.add(edge);
            return;
        }
        if (left != right) {
            return;
        }
        ListIterator<SegmentEdge> iter = this.edges.listIterator(this.edges.size());
        while (iter.hasPrevious()) {
            SegmentEdge next = iter.previous();
            if (this.comparator.compare(next.offset, left) > 0) continue;
            if (!next.leftEdge) {
                iter.next();
                edge = new SegmentEdge(left, true);
                iter.add(edge);
                edge = new SegmentEdge(right, false);
                iter.add(edge);
            }
            return;
        }
        if (edge == null) {
            edge = new SegmentEdge(right, false);
            this.edges.addFirst(edge);
            edge = new SegmentEdge(left, true);
            this.edges.addFirst(edge);
        }
    }

    public void normalize() {
        LinkedList<Object[]> sects = new LinkedList<Object[]>();
        if (!this.edges.isEmpty()) {
            SegmentEdge start = this.edges.getFirst();
            if (!start.leftEdge) {
                start = new SegmentEdge(LEFT_MOST_EDGE, true);
                this.edges.addFirst(start);
            }
            SegmentEdge end = this.edges.getLast();
            if (end.leftEdge) {
                end = new SegmentEdge(RIGHT_MOST_EDGE, false);
                this.edges.addLast(end);
            }
            assert (this.edges.size() % 2 == 0);
            ListIterator edgesIter = this.edges.listIterator();
            while (edgesIter.hasNext()) {
                Object[] prevSect;
                SegmentEdge leftEdge = (SegmentEdge)edgesIter.next();
                SegmentEdge rightEdge = (SegmentEdge)edgesIter.next();
                if (sects.size() > 0 && leftEdge.offset.equals((prevSect = (Object[])sects.getLast())[1])) {
                    prevSect[1] = rightEdge.offset;
                    continue;
                }
                if (this.isSectEmpty(leftEdge.offset, rightEdge.offset)) continue;
                sects.add(new Object[]{leftEdge.offset, rightEdge.offset});
            }
        }
        this.sections = (Object[][])sects.toArray((T[])new Object[sects.size()][]);
    }

    private boolean isSectEmpty(Object leftEdge, Object rightEdge) {
        return rightEdge == LEFT_MOST_EDGE || leftEdge == RIGHT_MOST_EDGE;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.normalize();
        if (this.sections.length == 0) {
            return "[NONE]";
        }
        int i = 0;
        while (i < this.sections.length) {
            Object[] seg = this.sections[i];
            buffer.append("[");
            if (seg[0] == LEFT_MOST_EDGE && seg[1] == RIGHT_MOST_EDGE) {
                buffer.append("ALL");
            } else if (seg[0] == LEFT_MOST_EDGE && seg[1] == LEFT_MOST_EDGE) {
                buffer.append("NONE");
            } else {
                if (seg[0] != LEFT_MOST_EDGE) {
                    buffer.append(seg[0]);
                }
                buffer.append("-");
                if (seg[1] != RIGHT_MOST_EDGE) {
                    buffer.append(seg[1]);
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    static class SegmentEdge {
        Object offset;
        boolean leftEdge;

        SegmentEdge(Object offset, boolean leftEdge) {
            this.offset = offset;
            this.leftEdge = leftEdge;
        }
    }
}

