/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class PropertyValueUtil {
    private static ExtensionManifest em;

    static {
        try {
            em = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.datatools.enablement.oda.ws");
        }
        catch (OdaException odaException) {}
    }

    public static String getQualifiedValueForDataSource(String value, String propName) {
        if (value != null && value.trim().length() == 0 && PropertyValueUtil.allowsEmptyValueAsNull(propName)) {
            return null;
        }
        return value;
    }

    public static String getQualifiedValueForDataSet(String value, String propName, String dataSetType) {
        if (value != null && value.trim().length() == 0 && PropertyValueUtil.allowsEmptyValueAsNull(propName, dataSetType)) {
            return null;
        }
        return value;
    }

    private static boolean allowsEmptyValueAsNull(String propName) {
        Property prop;
        boolean allowsEmptyValueAsNull = true;
        if (em != null && (prop = em.getProperty(propName)) != null) {
            return prop.allowsEmptyValueAsNull();
        }
        return allowsEmptyValueAsNull;
    }

    private static boolean allowsEmptyValueAsNull(String propName, String dataSetType) {
        boolean allowsEmptyValueAsNull = true;
        if (em != null) {
            Property prop;
            DataSetType dataType = null;
            try {
                dataType = em.getDataSetType(dataSetType);
            }
            catch (OdaException odaException) {}
            if (dataType != null && (prop = dataType.getProperty(propName)) != null) {
                return prop.allowsEmptyValueAsNull();
            }
        }
        return allowsEmptyValueAsNull;
    }
}

