/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.annotation.Annotation;
import org.eclipse.wst.xml.core.internal.contentmodel.annotation.AnnotationMap;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation.AnnotationFileInfo;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AnnotationFileParser {
    public static final String TAG_ID_ANNOTATIONS = "abstractGrammarAnnotations";
    public static final String TAG_ID_ANNOTATION = "annotation";
    public static final String TAG_ID_PROPERTY = "property";

    private void parse(AnnotationMap annotationMap, InputStream input, AnnotationFileInfo fileInfo) throws Exception {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(input), (DefaultHandler)new AnnotationMapContentHandler(annotationMap, fileInfo));
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    public void parse(AnnotationMap map, AnnotationFileInfo fileInfo) throws Exception {
        InputStream inputStream = null;
        try {
            try {
                URL url = Platform.find((Bundle)Platform.getBundle((String)fileInfo.getBundleId()), (IPath)Path.fromOSString((String)fileInfo.getAnnotationFileLocation()));
                if (url != null) {
                    inputStream = url.openStream();
                    this.parse(map, inputStream, fileInfo);
                }
            }
            catch (Exception e) {
                Logger.log(202, e.getMessage(), e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected class AnnotationMapContentHandler
    extends DefaultHandler {
        private AnnotationMap annotationMap;
        private Annotation currentAnnotation;
        private String currentPropertyName;
        private StringBuffer propertyValueBuffer;
        private ResourceBundle resourceBundle;
        private AnnotationFileInfo fFileInfo;

        public AnnotationMapContentHandler(AnnotationMap annotationMap, AnnotationFileInfo fileInfo) {
            this.annotationMap = annotationMap;
            this.fFileInfo = fileInfo;
        }

        private URL generatePropertiesFileURL(AnnotationFileInfo fileInfo, String propertiesLocation) {
            URL propertiesURL = null;
            IPath annotationPath = Path.fromOSString((String)("$nl$/" + fileInfo.getAnnotationFileLocation()));
            IPath annotationFolder = annotationPath.removeLastSegments(1);
            IPath propertiesFile = annotationFolder.append(propertiesLocation);
            if (propertiesFile.getFileExtension() == null) {
                propertiesFile = propertiesFile.addFileExtension("properties");
            }
            propertiesURL = Platform.find((Bundle)Platform.getBundle((String)fileInfo.getBundleId()), (IPath)propertiesFile);
            return propertiesURL;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.propertyValueBuffer = new StringBuffer();
            if (localName.equals(AnnotationFileParser.TAG_ID_ANNOTATIONS)) {
                int attributesLength = attributes.getLength();
                int i = 0;
                while (i < attributesLength) {
                    block25: {
                        String attributeName = attributes.getLocalName(i);
                        String attributeValue = attributes.getValue(i);
                        if (attributeName.equals("propertiesLocation")) {
                            URL bundleURL = this.generatePropertiesFileURL(this.fFileInfo, attributeValue);
                            if (bundleURL != null) {
                                InputStream bundleStream = null;
                                try {
                                    try {
                                        bundleStream = bundleURL.openStream();
                                        this.resourceBundle = new PropertyResourceBundle(bundleStream);
                                    }
                                    catch (IOException e) {
                                        Logger.log(202, e.getMessage(), e);
                                        try {
                                            if (bundleStream != null) {
                                                bundleStream.close();
                                            }
                                            break block25;
                                        }
                                        catch (IOException x) {
                                            Logger.log(202, x.getMessage(), x);
                                        }
                                        break block25;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (bundleStream != null) {
                                            bundleStream.close();
                                        }
                                    }
                                    catch (IOException x) {
                                        Logger.log(202, x.getMessage(), x);
                                    }
                                    throw throwable;
                                }
                                try {
                                    if (bundleStream != null) {
                                        bundleStream.close();
                                    }
                                }
                                catch (IOException x) {
                                    Logger.log(202, x.getMessage(), x);
                                }
                            }
                        } else if (attributeName.equals("caseSensitive") && attributeValue.trim().equals("false")) {
                            this.annotationMap.setCaseSensitive(false);
                        }
                    }
                    ++i;
                }
            } else if (localName.equals(AnnotationFileParser.TAG_ID_ANNOTATION)) {
                this.currentAnnotation = null;
                String specValue = attributes.getValue("spec");
                if (specValue != null) {
                    this.currentAnnotation = new Annotation();
                    this.currentAnnotation.setSpec(specValue);
                }
                this.annotationMap.addAnnotation(this.currentAnnotation);
            } else if (localName.equals(AnnotationFileParser.TAG_ID_PROPERTY) && this.currentAnnotation != null) {
                this.currentPropertyName = attributes.getValue("name");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String propertyValue;
            if (this.currentPropertyName != null && this.currentAnnotation != null && (propertyValue = this.propertyValueBuffer.toString()) != null) {
                if (propertyValue.startsWith("%") && this.resourceBundle != null) {
                    try {
                        propertyValue = this.resourceBundle.getString(propertyValue.substring(1));
                    }
                    catch (Exception exception) {}
                }
                this.currentAnnotation.setProperty(this.currentPropertyName, propertyValue);
            }
            if (localName.equals(AnnotationFileParser.TAG_ID_ANNOTATION)) {
                this.currentAnnotation = null;
            } else if (localName.equals(AnnotationFileParser.TAG_ID_PROPERTY)) {
                this.currentPropertyName = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currentPropertyName != null && this.currentAnnotation != null) {
                this.propertyValueBuffer.append(ch, start, length);
            }
        }
    }
}

