/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.IAcceleoLanguageServerContext;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;
import org.eclipse.acceleo.query.runtime.impl.namespace.workspace.QueryWorkspace;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;

public class AcceleoWorkspace
extends QueryWorkspace<AcceleoProject> {
    private AcceleoLanguageServer owner;
    private final Map<URI, AcceleoTextDocument> uriToDocuments = new LinkedHashMap<URI, AcceleoTextDocument>();
    private IAcceleoLanguageServerContext context;

    public AcceleoWorkspace(String name, IAcceleoLanguageServerContext context) {
        super(name);
        this.context = Objects.requireNonNull(context);
    }

    public void setOwner(AcceleoLanguageServer newOwner) {
        this.owner = newOwner;
    }

    public AcceleoLanguageServer getOwner() {
        return this.owner;
    }

    public synchronized String addResource(AcceleoProject project, URI resource) {
        IQueryWorkspaceQualifiedNameResolver resolver = this.getResolver(project);
        String qualifiedName = resolver.getQualifiedName(resource);
        if (qualifiedName != null) {
            resolver.clear(Collections.singleton(qualifiedName));
            Object resolved = resolver.resolve(qualifiedName);
            if (resolved instanceof Module) {
                URI sourceURI;
                String textDocumentContents = this.context.getResourceContents(resource);
                AcceleoTextDocument acceleoTextDocument = new AcceleoTextDocument(project, resource, qualifiedName, textDocumentContents, (Module)resolved);
                AcceleoTextDocument oldAcceleoTextDocument = this.uriToDocuments.put(resource, acceleoTextDocument);
                if (oldAcceleoTextDocument != null && oldAcceleoTextDocument.isOpened()) {
                    sourceURI = resolver.getSourceURI(qualifiedName);
                    this.getOwner().getTextDocumentService().close(sourceURI);
                    this.getOwner().getTextDocumentService().open(sourceURI, acceleoTextDocument);
                    acceleoTextDocument.open(textDocumentContents);
                }
                if ((sourceURI = resolver.getSourceURI(qualifiedName)) != null) {
                    this.uriToDocuments.put(sourceURI, acceleoTextDocument);
                }
                project.addDocument(acceleoTextDocument);
            }
        }
        return super.addResource((Object)project, resource);
    }

    public String removeResource(AcceleoProject project, URI resource) {
        AcceleoTextDocument removedDocument = this.uriToDocuments.remove(resource);
        if (removedDocument != null) {
            project.removeDocument(removedDocument);
            this.uriToDocuments.remove(this.getResolver(project).getURI(removedDocument.getModuleQualifiedName()));
            this.uriToDocuments.remove(this.getResolver(project).getSourceURI(removedDocument.getModuleQualifiedName()));
        }
        return super.removeResource((Object)project, resource);
    }

    public String moveResource(AcceleoProject sourceProject, URI sourceResource, AcceleoProject targetProject, URI targetResource) {
        Object resolved;
        IQueryWorkspaceQualifiedNameResolver resolver;
        String qualifiedName;
        AcceleoTextDocument removedDocument = this.uriToDocuments.remove(sourceResource);
        if (removedDocument != null) {
            sourceProject.removeDocument(removedDocument);
            this.uriToDocuments.remove(this.getResolver(sourceProject).getURI(removedDocument.getModuleQualifiedName()));
            this.uriToDocuments.remove(this.getResolver(sourceProject).getSourceURI(removedDocument.getModuleQualifiedName()));
        }
        if ((qualifiedName = (resolver = this.getResolver(targetProject)).getQualifiedName(targetResource)) != null && (resolved = resolver.resolve(qualifiedName)) instanceof Module) {
            String textDocumentContents = this.context.getResourceContents(targetResource);
            AcceleoTextDocument acceleoTextDocument = new AcceleoTextDocument(targetProject, targetResource, qualifiedName, textDocumentContents, (Module)resolved);
            this.uriToDocuments.put(targetResource, acceleoTextDocument);
            URI sourceURI = resolver.getSourceURI(qualifiedName);
            if (sourceURI != null) {
                this.uriToDocuments.put(sourceURI, acceleoTextDocument);
            }
            targetProject.addDocument(acceleoTextDocument);
        }
        return super.moveResource((Object)sourceProject, sourceResource, (Object)targetProject, targetResource);
    }

    public AcceleoTextDocument getDocument(URI resource) {
        return this.uriToDocuments.get(resource);
    }

    protected void updateResourceContents(AcceleoProject project, IQualifiedNameResolver resolver, URI resource) {
        AcceleoTextDocument acceleoTextDocument = this.uriToDocuments.get(resource);
        if (acceleoTextDocument != null) {
            acceleoTextDocument.setContents(this.context.getResourceContents(resource));
        }
    }

    protected void validate(AcceleoProject project, IQualifiedNameResolver resolver, String qualifiedName, boolean forEPackage) {
        AcceleoTextDocument acceleoTextDocument = project.getDocument(qualifiedName);
        if (acceleoTextDocument != null) {
            if (forEPackage) {
                acceleoTextDocument.parseContents();
            }
            acceleoTextDocument.validateAndPublishResults();
        }
    }

    protected IQualifiedNameLookupEngine getLookupEngine(AcceleoProject project, IQualifiedNameResolver resolver, String qualifiedName) {
        AcceleoTextDocument acceleoTextDocument = project.getDocument(qualifiedName);
        IQualifiedNameLookupEngine res = acceleoTextDocument != null && acceleoTextDocument.getQueryEnvironment() != null ? acceleoTextDocument.getQueryEnvironment().getLookupEngine() : null;
        return res;
    }

    protected IQueryWorkspaceQualifiedNameResolver createResolver(AcceleoProject project) {
        return this.context.createResolver(project);
    }

    public Set<AcceleoTextDocument> getAllTextDocuments() {
        return new LinkedHashSet<AcceleoTextDocument>(this.uriToDocuments.values());
    }

    public AcceleoProject getProject(URI resource) {
        return this.context.getProject(this, resource);
    }

    public Set<String> getExtensions() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        res.add("class");
        res.add("mtl");
        return res;
    }
}

