/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum DataChangeTrigger implements UaEnumeration
{
    Status(0),
    StatusValue(1),
    StatusValueTimestamp(2);

    private final int value;

    private DataChangeTrigger(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static DataChangeTrigger from(int value) {
        switch (value) {
            case 0: {
                return Status;
            }
            case 1: {
                return StatusValue;
            }
            case 2: {
                return StatusValueTimestamp;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=717");
    }

    public static class Codec
    extends GenericDataTypeCodec<DataChangeTrigger> {
        @Override
        public Class<DataChangeTrigger> getType() {
            return DataChangeTrigger.class;
        }

        @Override
        public DataChangeTrigger decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, DataChangeTrigger.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DataChangeTrigger value) {
            encoder.writeEnum(null, value);
        }
    }
}

