/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StyledTextCellEditor
extends CellEditor {
    protected StyledText text;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private static final int DEFAULT_STYLE = 4;

    public StyledTextCellEditor() {
        this.setStyle(4);
    }

    public StyledTextCellEditor(Composite parent) {
        this(parent, 4);
    }

    public StyledTextCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Control createControl(Composite parent) {
        this.text = this.createStyledText(parent);
        this.text.addVerifyKeyListener(event -> {
            if (event.doit && !this.isProposalPopupOpen()) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    boolean commit;
                    boolean bl = commit = event.stateMask != SWT.MOD3;
                    if (this.isCommitWithCtrlKey()) {
                        boolean bl2 = commit = event.stateMask == SWT.MOD1;
                    }
                    if (commit) {
                        this.fireApplyEditorValue();
                        this.deactivate();
                        event.doit = false;
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    this.fireCancelEditor();
                    event.doit = false;
                }
            }
        });
        this.text.addKeyListener(KeyListener.keyReleasedAdapter(event -> {
            if (this.getControl() == null || this.getControl().isDisposed()) {
                return;
            }
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }));
        this.text.addTraverseListener(e -> {
            if (e.detail == 2 || e.detail == 4) {
                e.doit = false;
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                StyledTextCellEditor.this.checkSelection();
                StyledTextCellEditor.this.checkDeleteable();
                StyledTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                StyledTextCellEditor.this.focusLost();
            }
        });
        this.text.setFont(parent.getFont());
        this.text.setBackground(parent.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    protected void focusLost() {
        if (!this.isProposalPopupOpen()) {
            super.focusLost();
        }
    }

    protected StyledText createStyledText(Composite parent) {
        return new StyledText(parent, this.getStyle());
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof String ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText((String)value);
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData data = new CellEditor.LayoutData();
        data.minimumWidth = 0;
        return data;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = this::editOccured;
        }
        return this.modifyListener;
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretOffset() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text == null || this.text.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.text == null || this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretOffset();
            if (pos < this.text.getCharCount()) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected boolean dependsOnExternalFocusListener() {
        return ((Object)((Object)this)).getClass() != StyledTextCellEditor.class;
    }

    protected boolean isProposalPopupOpen() {
        return false;
    }

    private boolean isCommitWithCtrlKey() {
        return (this.getStyle() & 2) != 0;
    }
}

