/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fordiac.ide.library.ui.wizards.LibrarySelectionPage;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.InitialNameGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.osgi.framework.VersionRange;

public class New4diacProjectPage
extends WizardNewProjectCreationPage {
    public static final String APPLICATION_NAME_POSTFIX = "App";
    private boolean openApplication = true;
    private Button advancedButton;
    private InitialNameGroup systemName;
    private InitialNameGroup applicationName;
    private int linkedResourceGroupHeight = -1;
    private Composite advancedGroupContainer;
    private Composite advancedGroupParent;
    private boolean blockListeners = false;
    private final Listener nameModifyListener = e -> {
        if (!this.blockListeners) {
            this.setPageComplete(this.validatePage());
        }
    };
    private LibrarySelectionPage libPage;
    private static final String[] comboLabels = new String[]{"current", "old", "none"};
    private static final VersionRange[] comboValues = new VersionRange[]{new VersionRange("3.0.0"), new VersionRange("[1.0.0,1.0.0]"), new VersionRange("(0.0.0,0.0.0)")};

    public New4diacProjectPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.systemName = new InitialNameGroup((Composite)this.getControl(), Messages.New4diacProjectWizard_InitialSystemName);
        this.systemName.addNameModifyListener(this.nameModifyListener);
        this.applicationName = new InitialNameGroup((Composite)this.getControl(), Messages.New4diacProjectWizard_InitialApplicationName);
        this.applicationName.addNameModifyListener(this.nameModifyListener);
        this.createAdvancedControls((Composite)this.getControl());
        Composite composite = (Composite)this.getControl();
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected boolean validatePage() {
        this.blockListeners = true;
        try {
            if (IdentifierVerifier.verifyIdentifier((String)this.getProjectName()).isPresent()) {
                this.setErrorMessage(Messages.New4diacProjectWizard_SystemNameNotValid);
                return false;
            }
            if (!this.systemName.validateName(this.getProjectName())) {
                return false;
            }
            if (!this.applicationName.validateName(this.getProjectName() + APPLICATION_NAME_POSTFIX)) {
                return false;
            }
            if (!super.validatePage()) {
                return false;
            }
            if (this.useDefaults() && New4diacProjectPage.projectNameExistsinWSPath(this.getProjectName())) {
                this.setErrorMessage(Messages.New4diacProjectWizard_DirectoryWithProjectNameAlreadyExistsInWorkspace);
                return false;
            }
        }
        finally {
            this.blockListeners = false;
        }
        return true;
    }

    public String getInitialSystemName() {
        return this.systemName.getInitialName();
    }

    public String getInitialApplicationName() {
        return this.applicationName.getInitialName();
    }

    public boolean getOpenApplication() {
        return this.openApplication;
    }

    private void createAdvancedControls(Composite parent) {
        this.advancedGroupParent = new Composite(parent, 0);
        this.advancedGroupParent.setFont(parent.getFont());
        this.advancedGroupParent.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.advancedGroupParent.setLayout((Layout)layout);
        this.advancedButton = new Button(this.advancedGroupParent, 8);
        this.advancedButton.setFont(this.advancedGroupParent.getFont());
        this.advancedButton.setText(Messages.NewSystemWizard_ShowAdvanced);
        GridData data = this.setButtonLayoutData(this.advancedButton);
        data.horizontalAlignment = 1;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                New4diacProjectPage.this.handleAdvancedButtonSelect();
            }
        });
    }

    protected void handleAdvancedButtonSelect() {
        if (this.advancedGroupContainer != null) {
            this.advancedGroupContainer.dispose();
            this.advancedGroupContainer = null;
            this.advancedButton.setText(Messages.NewSystemWizard_ShowAdvanced);
        } else {
            this.createAdvancedGroup();
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.advancedGroupContainer.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            this.advancedButton.setText(Messages.NewSystemWizard_HideAdvanced);
        }
        Composite compo = (Composite)this.getControl();
        compo.layout();
    }

    private void createAdvancedGroup() {
        this.advancedGroupContainer = new Composite(this.advancedGroupParent, 0);
        this.advancedGroupContainer.setLayout((Layout)new GridLayout());
        this.advancedGroupContainer.setLayoutData((Object)new GridData(768));
        Button openApplicationCheckbox = new Button(this.advancedGroupContainer, 32);
        openApplicationCheckbox.setText(Messages.OpenApplicationForEditing);
        openApplicationCheckbox.setSelection(this.openApplication);
        openApplicationCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                New4diacProjectPage.this.openApplication = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                New4diacProjectPage.this.openApplication = false;
            }
        });
        Label standardLibraryLabel = new Label(this.advancedGroupContainer, 0);
        standardLibraryLabel.setText("Import standard libraries:");
        final Combo standardLibraryCombo = new Combo(this.advancedGroupContainer, 4);
        int i = 0;
        while (i < comboLabels.length) {
            standardLibraryCombo.add(comboLabels[i], i);
            ++i;
        }
        standardLibraryCombo.select(0);
        standardLibraryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (New4diacProjectPage.this.libPage != null) {
                    New4diacProjectPage.this.libPage.setStandardLibRange(comboValues[standardLibraryCombo.getSelectionIndex()]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (New4diacProjectPage.this.libPage != null) {
                    New4diacProjectPage.this.libPage.setStandardLibRange(comboValues[standardLibraryCombo.getSelectionIndex()]);
                }
            }
        });
    }

    public void setLibraryPage(LibrarySelectionPage libraryPage) {
        this.libPage = libraryPage;
        this.libPage.setStandardLibRange(comboValues[0]);
    }

    private static boolean projectNameExistsinWSPath(String projectName) {
        IPath wsPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath localProjectPath = wsPath.append(projectName);
        return localProjectPath.toFile().exists();
    }
}

