/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.structuredtextcore.resource.STCoreResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.STCoreChangeSerializer;
import org.eclipse.xtext.ide.refactoring.IResourceRelocationStrategy;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationChange;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationContext;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public class STCoreResourceRelocationStrategy
implements IResourceRelocationStrategy {
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public void applyChange(ResourceRelocationContext context) {
        if (!(context.getChangeSerializer() instanceof STCoreChangeSerializer)) {
            return;
        }
        context.getChanges().stream().filter(this::isRelevant).forEach(change -> this.applyChange(context, (ResourceRelocationChange)change));
    }

    protected void applyChange(ResourceRelocationContext context, ResourceRelocationChange change) {
        context.addModification(change, resource -> this.modifyResource((Resource)resource, change, context.getChangeType()));
    }

    protected void modifyResource(Resource resource, ResourceRelocationChange change, ResourceRelocationContext.ChangeType changeType) {
        STCoreResource coreResource;
        if (resource instanceof STCoreResource && (coreResource = (STCoreResource)resource).getInternalLibraryElement() != null) {
            this.updateTypeName(coreResource, change);
            if (changeType != ResourceRelocationContext.ChangeType.RENAME) {
                this.updatePackageName(coreResource, change);
            }
        }
    }

    protected void updateTypeName(STCoreResource resource, ResourceRelocationChange change) {
        String newName;
        String oldName = resource.getInternalLibraryElement().getName();
        if (!oldName.equals(newName = TypeEntry.getTypeNameFromFileName((String)change.getToURI().lastSegment()))) {
            this.updateTypeName(resource, oldName, newName);
        }
    }

    protected void updatePackageName(STCoreResource resource, ResourceRelocationChange change) {
        String newPackageName;
        String oldPackageName = PackageNameHelper.getPackageName((LibraryElement)resource.getInternalLibraryElement());
        if (!oldPackageName.equals(newPackageName = PackageNameHelper.getPackageNameFromURI((URI)change.getToURI()))) {
            this.updatePackageName(resource, oldPackageName, newPackageName);
        }
    }

    protected void updateTypeName(STCoreResource resource, String oldName, String newName) {
        resource.getInternalLibraryElement().setName(newName);
    }

    protected void updatePackageName(STCoreResource resource, String oldPackageName, String newPackageName) {
        STSource source;
        EAttribute nameAttribute;
        EObject eObject = resource.getParseResult().getRootASTElement();
        if (eObject instanceof STSource && (nameAttribute = SimpleAttributeResolver.NAME_RESOLVER.getAttribute((EObject)(source = (STSource)eObject))) != null) {
            if (newPackageName == null || newPackageName.isEmpty()) {
                source.eUnset((EStructuralFeature)nameAttribute);
            } else {
                source.eSet((EStructuralFeature)nameAttribute, (Object)newPackageName);
            }
        }
        PackageNameHelper.setPackageName((LibraryElement)resource.getInternalLibraryElement(), (String)newPackageName);
    }

    protected boolean isRelevant(ResourceRelocationChange change) {
        String fileExtension = change.getFromURI().fileExtension();
        return fileExtension != null && this.fileExtensionProvider.isValid(fileExtension.toLowerCase()) && !this.fileExtensionProvider.getPrimaryFileExtension().equalsIgnoreCase(fileExtension);
    }
}

