/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.util.LibraryElementHashException;

public interface TypeEntry
extends Notifier {
    public static final String TYPE_ENTRY_FILE_FEATURE = "TYPE_ENTRY_FILE_FEATURE";
    public static final String TYPE_ENTRY_FILE_CONTENT_FEATURE = "TYPE_ENTRY_FILE_CONTENT_FEATURE";
    public static final String TYPE_ENTRY_TYPE_FEATURE = "TYPE_ENTRY_TYPE_FEATURE";
    public static final String TYPE_ENTRY_TYPE_EDITABLE_FEATURE = "TYPE_ENTRY_TYPE_EDITABLE_FEATURE";
    public static final String TYPE_ENTRY_TYPE_LIBRARY_FEATURE = "TYPE_ENTRY_TYPE_LIBRARY";
    public static final String TYPE_ENTRY_EDITOR_INSTANCE_UPDATE_FEATURE = "TYPE_ENTRY_EDITOR_INSTANCE_UPDATE_FEATURE";
    public static final String TYPE_ENTRY_INTERFACE_FEATURE = "TYPE_ENTRY_INTERFACE_FEATURE";
    public static final int TYPE_ENTRY_FILE_FEATURE_ID = 1;
    public static final int TYPE_ENTRY_FILE_CONTENT_FEATURE_ID = 2;
    public static final int TYPE_ENTRY_TYPE_FEATURE_ID = 3;
    public static final int TYPE_ENTRY_TYPE_EDITABLE_FEATURE_ID = 4;
    public static final int TYPE_ENTRY_TYPE_LIBRARY_FEATURE_ID = 5;
    public static final int TYPE_ENTRY_EDITOR_INSTANCE_UPDATE_FEATURE_ID = 6;
    public static final int TYPE_ENTRY_INTERFACE_FEATURE_ID = 7;

    public IFile getFile();

    public void setFile(IFile var1);

    public LibraryElement getType();

    public void setType(LibraryElement var1);

    @Deprecated(since="3.0.0", forRemoval=true)
    public LibraryElement getTypeEditable();

    @Deprecated(since="3.0.0", forRemoval=true)
    public void setTypeEditable(LibraryElement var1);

    public TypeLibrary getTypeLibrary();

    public void setTypeLibrary(TypeLibrary var1);

    public LibraryElement copyType();

    default public void save(LibraryElement toSave) throws CoreException {
        this.save(toSave, (IProgressMonitor)new NullProgressMonitor());
    }

    public void save(LibraryElement var1, IProgressMonitor var2) throws CoreException;

    public String getTypeName();

    public String getFullTypeName();

    public String getFileExtension();

    public String getComment();

    public EClass getTypeEClass();

    default public String getPackageName() {
        return PackageNameHelper.extractPackageName(this.getFullTypeName());
    }

    public Set<TypeEntry> getDependencies();

    public String getTypeHash() throws LibraryElementHashException;

    public void refresh();

    public static String getTypeNameFromFile(IFile element) {
        return TypeEntry.getTypeNameFromFileName(element.getName());
    }

    public static String getTypeNameFromFileName(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (-1 != index) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    default public URI getURI() {
        IFile file = this.getFile();
        if (file != null) {
            return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        }
        return null;
    }
}

