/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class FBEndpointFinder {
    protected FBEndpointFinder() {
    }

    public static void traceMembers(MemberVarDeclaration startDecl, Set<IInterfaceElement> connectedIfs) {
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(startDecl.getName());
        FBEndpointFinder.trace(new RecursionState(new ArrayDeque<String>(), !startDecl.isIsInput(), startDecl, connectedIfs, true));
    }

    public static Set<BlockFBNetworkElement> findDestinations(BlockFBNetworkElement from) {
        return FBEndpointFinder.findConnectedElements(from, false, true, true).keySet();
    }

    public static Set<BlockFBNetworkElement> findSources(BlockFBNetworkElement from) {
        return FBEndpointFinder.findConnectedElements(from, true, false, true).keySet();
    }

    public static Set<BlockFBNetworkElement> findAllConnectedElements(BlockFBNetworkElement from) {
        return FBEndpointFinder.findConnectedElements(from, true, true, true).keySet();
    }

    public static Set<IInterfaceElement> findConnectedInterfaceElements(IInterfaceElement ifElem) {
        HashSet<IInterfaceElement> connectedInt = new HashSet<IInterfaceElement>();
        for (Connection con : ifElem.isIsInput() ? ifElem.getInputConnections() : ifElem.getOutputConnections()) {
            FBEndpointFinder.trace(new RecursionState(new ArrayDeque<String>(), ifElem.isIsInput(), ifElem.isIsInput() ? con.getSource() : con.getDestination(), connectedInt, false));
        }
        return connectedInt;
    }

    public static Set<IInterfaceElement> findConnectedInterfaceElements(Connection connection, boolean traceThroughInput) {
        HashSet<IInterfaceElement> connectedInt = new HashSet<IInterfaceElement>();
        FBEndpointFinder.trace(new RecursionState(new ArrayDeque<String>(), traceThroughInput, traceThroughInput ? connection.getSource() : connection.getDestination(), connectedInt, false));
        return connectedInt;
    }

    public static Map<IInterfaceElement, Set<IInterfaceElement>> findConnectedInterfaces(BlockFBNetworkElement fb) {
        HashMap<IInterfaceElement, Set<IInterfaceElement>> results = new HashMap<IInterfaceElement, Set<IInterfaceElement>>();
        ArrayList<IInterfaceElement> outInt = new ArrayList<IInterfaceElement>();
        outInt.addAll((Collection<IInterfaceElement>)fb.getInterface().getEventOutputs());
        outInt.addAll((Collection<IInterfaceElement>)fb.getInterface().getOutputVars());
        outInt.addAll((Collection<IInterfaceElement>)fb.getInterface().getPlugs());
        FBEndpointFinder.flattenConnections(outInt, false).forEach(con -> {
            Set<IInterfaceElement> set = results.put(con.getSource(), FBEndpointFinder.findConnectedInterfaceElements(con.getSource()));
        });
        return results;
    }

    public static Map<BlockFBNetworkElement, Integer> findConnectedElements(BlockFBNetworkElement fb, boolean includeInputs, boolean includeOutputs, boolean traverseParent) {
        ArrayList<IInterfaceElement> ifs = new ArrayList<IInterfaceElement>();
        if (includeInputs) {
            ifs.addAll((Collection<IInterfaceElement>)fb.getInterface().getEventInputs());
            ifs.addAll((Collection<IInterfaceElement>)fb.getInterface().getInputVars());
            ifs.addAll((Collection<IInterfaceElement>)fb.getInterface().getSockets());
        }
        if (includeOutputs) {
            ifs.addAll((Collection<IInterfaceElement>)fb.getInterface().getEventOutputs());
            ifs.addAll((Collection<IInterfaceElement>)fb.getInterface().getOutputVars());
            ifs.addAll((Collection<IInterfaceElement>)fb.getInterface().getPlugs());
        }
        HashSet connectedIfs = new HashSet();
        ifs.stream().forEach(ifElem -> (ifElem.isIsInput() ? ifElem.getInputConnections() : ifElem.getOutputConnections()).forEach(con -> FBEndpointFinder.trace(new RecursionState(new ArrayDeque<String>(), ifElem.isIsInput(), ifElem.isIsInput() ? con.getSource() : con.getDestination(), connectedIfs, false))));
        HashMap<BlockFBNetworkElement, Integer> result = new HashMap<BlockFBNetworkElement, Integer>();
        connectedIfs.stream().map(IInterfaceElement::getBlockFBNetworkElement).forEach(destFB -> {
            Integer n = result.put((BlockFBNetworkElement)destFB, result.containsKey(destFB) ? Integer.valueOf((Integer)result.get(destFB) + 1) : Integer.valueOf(1));
        });
        if (!traverseParent && fb.getOuterFBNetworkElement() != null) {
            ArrayList<FBNetworkElement> parents = new ArrayList<FBNetworkElement>();
            FBNetworkElement parent = fb.getOuterFBNetworkElement();
            while (parent != null) {
                parents.add(parent);
                parent = parent.getOuterFBNetworkElement();
            }
            result.keySet().removeIf(k -> parents.contains(k.getOuterFBNetworkElement()));
        }
        return result;
    }

    public static List<BlockFBNetworkElement> getConnectedFbs(List<BlockFBNetworkElement> connectedElements, BlockFBNetworkElement src) {
        ArrayList<BlockFBNetworkElement> foundElements = new ArrayList<BlockFBNetworkElement>();
        ArrayList<IInterfaceElement> pins = new ArrayList<IInterfaceElement>();
        pins.addAll((Collection<IInterfaceElement>)src.getInterface().getEventOutputs());
        pins.addAll((Collection<IInterfaceElement>)src.getInterface().getOutputVars());
        for (IInterfaceElement pin : pins) {
            foundElements.addAll(FBEndpointFinder.getConnectedFbs(pin));
        }
        if (!foundElements.isEmpty() && (foundElements.size() == 1 && !((BlockFBNetworkElement)foundElements.get(0)).equals(src) || foundElements.size() > 1)) {
            for (BlockFBNetworkElement element : foundElements) {
                if (element.equals(src) || connectedElements.contains(element)) continue;
                connectedElements.add(element);
                connectedElements = FBEndpointFinder.getConnectedFbs(connectedElements, element);
            }
        }
        return connectedElements.stream().distinct().toList();
    }

    private static List<BlockFBNetworkElement> getConnectedFbs(IInterfaceElement srcPin) {
        ArrayList<BlockFBNetworkElement> connectedElements = new ArrayList<BlockFBNetworkElement>();
        for (Connection con : srcPin.getOutputConnections()) {
            if (con.getDestinationElement() instanceof SubApp) {
                connectedElements.addAll(FBEndpointFinder.getConnectedFbs(con.getDestination()));
                continue;
            }
            connectedElements.add(con.getDestinationElement());
        }
        return connectedElements.stream().distinct().toList();
    }

    private static Stream<Connection> flattenConnections(List<? extends IInterfaceElement> fbInt, boolean inputs) {
        return fbInt.stream().flatMap(e -> inputs ? e.getInputConnections().stream() : e.getOutputConnections().stream());
    }

    private static void trace(RecursionState state) {
        SubApp subapp;
        if (state.ifElem == null) {
            return;
        }
        BlockFBNetworkElement fb = state.ifElem.getBlockFBNetworkElement();
        if (fb == null) {
            return;
        }
        if (!state.traceMember && state.ifElem instanceof Event) {
            FBEndpointFinder.traceEvent(state);
            return;
        }
        if (fb instanceof SubApp && !(subapp = (SubApp)fb).isTyped()) {
            FBEndpointFinder.traceSubApp(state);
        } else if (fb instanceof StructManipulator) {
            if (state.inputSide && fb instanceof Demultiplexer || !state.inputSide && fb instanceof Multiplexer) {
                FBEndpointFinder.traceTrunk(state);
            } else {
                FBEndpointFinder.traceFan(state);
            }
        } else {
            state.connections.add(state.ifElem);
        }
    }

    private static void traceEvent(RecursionState state) {
        SubApp subapp;
        BlockFBNetworkElement fb = state.ifElem.getBlockFBNetworkElement();
        if (fb instanceof SubApp && !(subapp = (SubApp)fb).isTyped()) {
            EList<Connection> subCons = state.inputSide ? state.ifElem.getInputConnections() : state.ifElem.getOutputConnections();
            subCons.forEach(subInt -> FBEndpointFinder.traceEvent(new RecursionState(null, recursionState.inputSide, recursionState.inputSide ? subInt.getSource() : subInt.getDestination(), recursionState.connections, false)));
            return;
        }
        if (fb instanceof StructManipulator) {
            EList<Connection> plexCons = state.inputSide ? ((Event)fb.getInterface().getEventInputs().get(0)).getInputConnections() : ((Event)fb.getInterface().getEventOutputs().get(0)).getOutputConnections();
            plexCons.forEach(nextInt -> FBEndpointFinder.traceEvent(new RecursionState(null, recursionState.inputSide, recursionState.inputSide ? nextInt.getSource() : nextInt.getDestination(), recursionState.connections, false)));
            return;
        }
        state.connections.add(state.ifElem);
    }

    private static void traceSubApp(RecursionState state) {
        EList<Connection> subCons = state.inputSide ? state.ifElem.getInputConnections() : state.ifElem.getOutputConnections();
        for (Connection subInt : subCons) {
            IInterfaceElement nextInterface;
            IInterfaceElement iInterfaceElement = nextInterface = state.inputSide ? subInt.getSource() : subInt.getDestination();
            if (state.traceMember && subInt.isVisible()) {
                state.connections.add(nextInterface);
                continue;
            }
            FBEndpointFinder.trace(new RecursionState(state.plexStack, state.inputSide, nextInterface, state.connections, state.traceMember));
        }
    }

    private static void traceTrunk(RecursionState state) {
        EList<Connection> varCons;
        EList<VarDeclaration> vars;
        BlockFBNetworkElement fb = state.ifElem.getBlockFBNetworkElement();
        EList<VarDeclaration> eList = vars = state.inputSide ? fb.getInterface().getInputVars() : fb.getInterface().getOutputVars();
        if (vars.isEmpty()) {
            return;
        }
        EList<Connection> eList2 = varCons = state.inputSide ? ((VarDeclaration)vars.get(0)).getInputConnections() : ((VarDeclaration)vars.get(0)).getOutputConnections();
        if (varCons.isEmpty()) {
            if (state.traceMember) {
                state.connections.add((IInterfaceElement)vars.get(0));
            }
            return;
        }
        state.plexStack.push(state.ifElem.getName());
        if (state.traceMember) {
            for (Connection con : varCons) {
                IInterfaceElement nextInterface;
                IInterfaceElement iInterfaceElement = nextInterface = state.inputSide ? con.getSource() : con.getDestination();
                if (con.isVisible()) {
                    state.connections.add(nextInterface);
                    continue;
                }
                FBEndpointFinder.trace(new RecursionState(state.plexStack, state.inputSide, nextInterface, state.connections, state.traceMember));
            }
        } else {
            FBEndpointFinder.trace(new RecursionState(state.plexStack, state.inputSide, state.inputSide ? ((Connection)varCons.get(0)).getSource() : ((Connection)varCons.get(0)).getDestination(), state.connections, state.traceMember));
        }
    }

    private static void traceFan(RecursionState state) {
        BlockFBNetworkElement fb = state.ifElem.getBlockFBNetworkElement();
        for (IInterfaceElement iInterfaceElement : ((StructManipulator)fb).getMemberVars().stream().filter(mem -> fb.getInterfaceElement(mem.getName()) != null).toList()) {
            Object subStack;
            IInterfaceElement realInt = fb.getInterfaceElement(iInterfaceElement.getName());
            if (state.plexStack.isEmpty()) {
                subStack = new ArrayDeque();
            } else {
                if (!iInterfaceElement.getName().equals(state.plexStack.peek())) continue;
                subStack = ((ArrayDeque)state.plexStack).clone();
                subStack.pop();
                if (state.traceMember && (subStack.isEmpty() || (state.inputSide ? realInt.getInputConnections().isEmpty() : realInt.getOutputConnections().isEmpty()))) {
                    state.connections.add(realInt);
                    continue;
                }
            }
            for (Connection next : state.inputSide ? realInt.getInputConnections() : realInt.getOutputConnections()) {
                IInterfaceElement nextInterface;
                IInterfaceElement iInterfaceElement2 = nextInterface = state.inputSide ? next.getSource() : next.getDestination();
                if (state.traceMember && next.isVisible()) {
                    state.connections.add(nextInterface);
                    continue;
                }
                FBEndpointFinder.trace(new RecursionState((Deque<String>)subStack, state.inputSide, nextInterface, state.connections, state.traceMember));
            }
        }
    }

    private static class RecursionState {
        public final Deque<String> plexStack;
        public final boolean inputSide;
        public final IInterfaceElement ifElem;
        public final Set<IInterfaceElement> connections;
        public final boolean traceMember;

        public RecursionState(Deque<String> plexStack, boolean inputSide, IInterfaceElement ifElem, Set<IInterfaceElement> connections, boolean traceMember) {
            this.plexStack = plexStack;
            this.inputSide = inputSide;
            this.ifElem = ifElem;
            this.connections = connections;
            this.traceMember = traceMember;
        }
    }
}

