/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.impl.AbstractTypeEntryImpl;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

abstract class AbstractCheckedTypeEntryImpl<T extends LibraryElement>
extends AbstractTypeEntryImpl {
    private final Class<T> typeClass;

    protected AbstractCheckedTypeEntryImpl(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public T getType() {
        LibraryElement type = super.getType();
        if (this.typeClass.isInstance(type)) {
            return (T)((LibraryElement)this.typeClass.cast(type));
        }
        return null;
    }

    @Deprecated(since="3.0.0", forRemoval=true)
    public T getTypeEditable() {
        LibraryElement type = super.getTypeEditable();
        if (this.typeClass.isInstance(type)) {
            return (T)((LibraryElement)this.typeClass.cast(type));
        }
        return null;
    }

    public T copyType() {
        LibraryElement type = super.copyType();
        if (this.typeClass.isInstance(type)) {
            return (T)((LibraryElement)this.typeClass.cast(type));
        }
        return null;
    }

    @Override
    public void save(LibraryElement toSave, IProgressMonitor monitor) throws CoreException {
        if (this.typeClass.isInstance(toSave)) {
            this.doSaveInternal(this.getTypeExporter((LibraryElement)this.typeClass.cast(toSave)), monitor);
        } else {
            FordiacLogHelper.logError((String)("Tried to save wrong type entry for " + this.getClass().getName()));
        }
    }

    @Override
    public void setType(LibraryElement type) {
        if (this.typeClass.isInstance(type)) {
            super.setType(type);
        } else {
            super.setType(null);
            if (type != null) {
                FordiacLogHelper.logError((String)("Tried to set wrong type entry for " + this.getClass().getName()));
            }
        }
    }

    protected abstract AbstractTypeExporter getTypeExporter(T var1);
}

