/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ConnectionHelper;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.BlockInstanceFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;

class FBNetworkImporter
extends CommonElementImporter {
    private final FBNetwork fbNetwork;
    private final InterfaceList interfaceList;
    private final Map<String, FBNetworkElement> fbNetworkElementMap;

    public FBNetworkImporter(CommonElementImporter importer) {
        this(importer, LibraryElementFactory.eINSTANCE.createFBNetwork(), LibraryElementFactory.eINSTANCE.createInterfaceList());
    }

    public FBNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork, InterfaceList interfaceList) {
        this(importer, fbNetwork, interfaceList, new HashMap<String, FBNetworkElement>());
    }

    protected FBNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork, Map<String, FBNetworkElement> fbNetworkElementMap) {
        this(importer, fbNetwork, LibraryElementFactory.eINSTANCE.createInterfaceList(), fbNetworkElementMap);
    }

    private FBNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork, InterfaceList interfaceList, Map<String, FBNetworkElement> fbNetworkElementMap) {
        super(importer);
        this.fbNetwork = fbNetwork;
        this.interfaceList = interfaceList;
        fbNetwork.getNetworkElements().forEach(element -> {
            FBNetworkElement fBNetworkElement = fbNetworkElementMap.put(element.getName(), (FBNetworkElement)element);
        });
        this.fbNetworkElementMap = fbNetworkElementMap;
    }

    public FBNetwork getFbNetwork() {
        return this.fbNetwork;
    }

    public InterfaceList getInterfaceList() {
        return this.interfaceList;
    }

    public void parseFBNetwork(String networkNodeName) throws TypeImportException, XMLStreamException {
        this.processChildren(networkNodeName, this::handleFBNetworkChild);
        this.moveElementsToGroup();
    }

    private void moveElementsToGroup() {
        this.getFbNetwork().getNetworkElements().stream().forEach(el -> {
            FBNetworkElement fBNetworkElement;
            Attribute groupAttr = el.getAttribute("GroupName");
            if (groupAttr != null && (fBNetworkElement = this.fbNetworkElementMap.get(groupAttr.getValue())) instanceof Group) {
                Group group = (Group)fBNetworkElement;
                el.setGroup(group);
                el.deleteAttribute("GroupName");
            }
        });
    }

    protected boolean handleFBNetworkChild(String name) throws XMLStreamException, TypeImportException {
        switch (name) {
            case "FB": {
                this.parseFB();
                break;
            }
            case "Group": {
                this.parseGroup();
                break;
            }
            case "Comment": {
                this.parseComment();
                break;
            }
            case "EventConnections": {
                this.parseConnectionList(LibraryElementPackage.eINSTANCE.getEventConnection(), this.fbNetwork.getEventConnections(), "EventConnections");
                break;
            }
            case "DataConnections": {
                this.parseConnectionList(LibraryElementPackage.eINSTANCE.getDataConnection(), this.fbNetwork.getDataConnections(), "DataConnections");
                break;
            }
            case "AdapterConnections": {
                this.parseConnectionList(LibraryElementPackage.eINSTANCE.getAdapterConnection(), this.fbNetwork.getAdapterConnections(), "AdapterConnections");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void parseGroup() throws TypeImportException, XMLStreamException {
        String locked;
        String height;
        Group group = LibraryElementFactory.eINSTANCE.createGroup();
        this.readNameCommentAttributes(group);
        this.getXandY(group);
        String width = this.getAttributeValue("width");
        if (width != null) {
            group.setWidth(Double.parseDouble(width));
        }
        if ((height = this.getAttributeValue("height")) != null) {
            group.setHeight(Double.parseDouble(height));
        }
        if ((locked = this.getAttributeValue("locked")) != null) {
            group.setLocked(Boolean.parseBoolean(locked));
        }
        this.addFBNetworkElement(group);
        this.processChildren("Group", tagName -> {
            if ("Attribute".equals(tagName)) {
                this.parseGenericAttributeNode(group);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
    }

    private void parseComment() throws TypeImportException, XMLStreamException {
        String height;
        Comment comment = LibraryElementFactory.eINSTANCE.createComment();
        this.readCommentAttribute(comment);
        this.getXandY(comment);
        String width = this.getAttributeValue("width");
        if (width != null) {
            comment.setWidth(Double.parseDouble(width));
        }
        if ((height = this.getAttributeValue("height")) != null) {
            comment.setHeight(Double.parseDouble(height));
        }
        this.fbNetwork.getNetworkElements().add((Object)comment);
        this.processChildren("Comment", name -> {
            if ("Attribute".equals(name)) {
                this.parseGenericAttributeNode(comment);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
        this.proceedToEndElementNamed("Comment");
    }

    private void parseFB() throws TypeImportException, XMLStreamException {
        String typeFbElement = this.getAttributeValue("Type");
        BlockFBNetworkElement fb = this.createFBInstance(typeFbElement);
        this.readNameCommentAttributes(fb);
        this.getXandY(fb);
        this.addFBNetworkElement(fb);
        this.parseFBChildren(fb, "FB");
    }

    protected void addFBNetworkElement(FBNetworkElement fb) {
        this.fbNetwork.getNetworkElements().add((Object)fb);
        this.fbNetworkElementMap.putIfAbsent(fb.getName(), fb);
    }

    private BlockFBNetworkElement createFBInstance(String typeName) {
        FBTypeEntry entry = this.getTypeEntry(typeName, this.getTypeLibrary()::getFBTypeEntry);
        if (entry == null) {
            return this.addDependency(FordiacMarkerHelper.createTypeErrorMarkerFB(typeName, this.getTypeLibrary(), LibraryElementPackage.eINSTANCE.getFBType()));
        }
        FB fb = BlockInstanceFactory.createFBInstanceForTypeEntry(entry);
        InterfaceList fbInterface = entry.getInterface();
        fbInterface = fbInterface == null ? LibraryElementFactory.eINSTANCE.createInterfaceList() : fbInterface.copy();
        fb.setInterface(fbInterface);
        fb.setTypeEntry(entry);
        return fb;
    }

    protected <T extends Connection> void parseConnectionList(EClass conType, EList<T> connectionlist, String parentNodeName) throws XMLStreamException, TypeImportException {
        this.processChildren(parentNodeName, name -> {
            Object connection = this.parseConnection(conType);
            if (connection != null) {
                connectionlist.add(connection);
            }
            this.proceedToEndElementNamed("Connection");
            return true;
        });
    }

    protected <T extends Connection> T parseConnection(EClass conType) throws XMLStreamException, TypeImportException {
        ConnectionHelper.ConnectionBuilder builder = ConnectionHelper.createConnectionBuilder(conType, this);
        builder.validate();
        builder.handleErrorCases();
        return builder.getConnection();
    }

    public <T extends Connection> void parseAttributes(T connection) throws XMLStreamException, TypeImportException {
        this.processChildren("Connection", tag -> {
            if ("Attribute".equals(tag)) {
                this.parseGenericAttributeNode(connection);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
    }

    IInterfaceElement getContainingInterfaceElement(String interfaceElement, EClass conType, boolean isInput) {
        return FBNetworkImporter.getInterfaceElement(this.interfaceList, interfaceElement, conType, !isInput);
    }

    static IInterfaceElement getInterfaceElement(InterfaceList il, String interfaceElement, EClass conType, boolean isInput) {
        Stream<? extends IInterfaceElement> ies = FBNetworkImporter.getInterfaceElementList(il, conType, isInput);
        return ies.filter(ie -> ie.getName().equals(interfaceElement)).findAny().orElse(null);
    }

    private static Stream<? extends IInterfaceElement> getInterfaceElementList(InterfaceList il, EClass conType, boolean isInput) {
        if (isInput) {
            if (LibraryElementPackage.eINSTANCE.getEventConnection() == conType) {
                return il.getEventInputs().stream();
            }
            if (LibraryElementPackage.eINSTANCE.getDataConnection() == conType) {
                return Stream.concat(il.getInputVars().stream(), il.getInOutVars().stream());
            }
            if (LibraryElementPackage.eINSTANCE.getAdapterConnection().equals(conType)) {
                return il.getSockets().stream();
            }
        } else {
            if (LibraryElementPackage.eINSTANCE.getEventConnection() == conType) {
                return il.getEventOutputs().stream();
            }
            if (LibraryElementPackage.eINSTANCE.getDataConnection() == conType) {
                return Stream.concat(il.getOutputVars().stream(), il.getOutMappedInOutVars().stream());
            }
            if (LibraryElementPackage.eINSTANCE.getAdapterConnection().equals(conType)) {
                return il.getPlugs().stream();
            }
        }
        return Stream.empty();
    }

    FBNetworkElement findFBNetworkElement(String fbName) {
        return this.fbNetworkElementMap.get(fbName);
    }

    @Override
    protected LibraryElement createRootModelElement() {
        return null;
    }

    @Override
    protected String getStartElementName() {
        return null;
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return null;
    }

    @Override
    protected <T extends FBNetworkElement> T addDependency(T element) {
        if (element != null) {
            this.addDependency(element.getTypeEntry());
        }
        return element;
    }
}

